//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015 

//Chapter-1 : Introduction
//Example: 1.3   Page 9
//Topic: Free Fall of ball in Air
//=======================================================================
model Ex1_3

//======================================================
// Parameter Section
parameter Real m(unit="Kg")=0.2"Mass of the body";
parameter Real yo(unit="m")=500"Height above ground";
parameter Real k(unit="N*s^2/m^2")=2E-4"Constant in Air resistance force equation";
parameter Real g(unit="m/s^2")=9.81"Acceleration Due to Gravity";
parameter Real y(unit="m")=0"Final Height above Ground";
//======================================================
// Variable Section
Real v(unit="m/s")"Actual Velocity";
Real vt(unit="m/s")"terminal Velocity";
Real r(unit="")"Ratio of actual velocity to Terminal velocity";

//======================================================
// Equation Section
equation
v=(m*g*(1-exp((2*k*(y-yo)/m)))/k)^0.5"Integrated Expression for Velocity";
vt=(m*g/k)^0.5"Expression for Terminal Speed";
r=v/vt"Ratio of Velocity and Terminal Speed";
end Ex1_3;
//=====================================================
