//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-10 : Fluid machinery
//Example: 10.11   Page:550
//Topic: Performance fo a positive displacement pump
//===================================================================================
model Ex10_11
//============================================================
//Parameter Section
parameter Real q(unit="L/min")=186"Volumetric flowrate";
parameter Real r(unit="rev/min")=2000"Rotational speed";
parameter Real c1(unit="mL^3/L")=1000"Unit converison constant";
parameter Real vp(unit="mL^3/rev")=97"volume of pump";
parameter Real q2(unit="L/min")=178"Volumetric flow rate at 10MPa";
parameter Real c2(unit="min/s")=1/60"Unit conversion constant";
parameter Real delp(unit="Pa")=10^7"Prssure drop";
parameter Real c3(unit="W*s/(Pa*m^3)")=1"Unit conversion constant";
parameter Real n(unit="")=0.84"Pump Efficiency";
parameter Real ql(unit="L/min")=75"Flowrate of fluid";
parameter Real pol(unit="Pa")=700E3"Difference between pump pressure and load";
parameter Real c4(unit="m^3/L")=1E-3"Unit conversion constant";
//============================================================
//Variable Section
Real v(unit="mL^3/min")"Calucated volume";
Real nv(unit="")"Volumetric efficiency";
Real pf(unit="W")"Power delivered to fluid";
Real pin(unit="W")"Power input";
Real pl(unit="W")"Power delivered to the load";
Real pd(unit="W")"Power dissipated";
Real pvd(unit="W")"Power disspipated with variable dispalcement pump";
Real pls(unit="W")"power dissipated by load sensing pump";

//============================================================
//Equation Section
equation
v=q*c1/r"Expression for v";
nv=v/vp"Expression for nv";
pf=q2*c4*delp*c2"Expression for pf";
pin=pf/n"Ëxpreession for pin";
pl=ql*c4*c2*c3*10*1E6"Expresion for pl";
pd=pf-pl"Expresion for pd";
pvd=ql*c4*c2*c3*1E7"Expression for pvd";
pls=ql*c4*c2*c3*pol"Expression for pls";
end Ex10_11;
//=============================================================
