//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-10 : Fluid machinery
//Example: 10.17   Page:570
//Topic: Sizing a marine propeller
//===================================================================================
model Ex10_17

//============================================================
//Parameter Section
parameter Real j(unit="")=0.85;
parameter Real cf(unit="")=0.1"Coefficient of friction";
parameter Real ct(unit="")=0.02;
parameter Real n(unit="")=0.66"Efficiency";
parameter Real v(unit="m/s")=6.69"Velocity";
parameter Real p(unit="kg/m^3")=1025"Density of water";
parameter Real pu(unit="W")=11.4E6"USeful power";
parameter Real c1(unit="N*m/(s*W)")=1"Unit Conversion constant";
parameter Real c2(unit="MN/N")=1e-6"Unit conversion constant";
parameter Real c3(unit="kg*m/(N*s^2)")=1"Unit conversion constant";
parameter Real c4(unit="min/s")=60"unit conversion constant";
//============================================================
//Variable Section
Real ft(unit="MN")"Propeller Thrust";
Real pin(unit="MW")"power input";
Real nd(unit="m/s");
Real d(unit="m")"Diameter of a single propeller to  power the ship";
Real n1(unit="rev/min")"Revolution speed";

//============================================================
//Equation Section
equation
ft=pu/v*c1*c2"Equation for ft";
pin=pu/n"Equation for pi";
nd=v/j"Equation for nd";
cf=ft*c3/(c2*p*(nd)^2*d^2)"Equation for cf";
n1=nd*c4/d"Equation for n";
end Ex10_17;
//==============================================================
