model Ex10_4
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-10 : Fluid machinery
  //Example: 10.4   Page:516
  //Topic: Calculation of pump charecteristics  from pump data
  //===================================================================================
  //============================================================
  //Parameter Section
  parameter Real q(unit = "m^3/hr") = 227 "Flow rate";
  parameter Real ps(unit = "kPa") = -39 "Suction pressure";
  parameter Real pd(unit = "kPa") = 230 "Discharge Pressure";
  parameter Real i(unit = "A") = 32.6 "Motor Current";
  parameter Real zs(unit = "m") = 0.3 "Head in suction side";
  parameter Real zd(unit = "m") = 0.9 "Head in discharge side";
  parameter Real p(unit = "kg/m^3") = 1000 "Density of water";
  parameter Real g(unit = "m/s^2") = 9.81 "Äcceleration due to gravity";
  parameter Real v(unit = "V") = 460 "Voltage";
  parameter Real n(unit = "") = 0.9 "Efficiency";
  parameter Real pf(unit = "") = 0.875 "factor";
  parameter Real c1(unit = "Pa*s^2*m/kg") = 1 "Unit conversion constant";
  parameter Real c2(unit = "W*s/(Pa*m^3)") = 1 "Unit conversion constant";
  parameter Real c3(unit = "W/(V*A)") = 1 "Unit conversdion constant";
  parameter Real c4(unit = "hr/sec") = 1 / 3600 "Unit conversion constant";
  //============================================================
  //Variable Section
  Real p1(unit = "Pa") "Suction pressure corrected to same elevation";
  Real p2(unit = "Pa") "Discahrge pressure corrected to same elevation";
  Real hp(unit = "m") "Pump Head";
  Real wh(unit = "W") "Hydraulic Power";
  Real pin(unit = "W") "Motor power output";
  Real eff(unit="")"Efficiency";
  //============================================================
  //Equation Section
equation
  p1 = ps * 1E3 + p * g * zs * c1 "Expression for p1";
  p2 = pd * 1E3 + p * g * zd * c1 "Expression for p2";
  hp = (p2 - p1) / (p * g * c1) "Expresion for hp";
  wh = q * c4 * (p2 - p1) * c2 "Expression for wh";
  pin = n * sqrt(3) * pf * v * i * c3 "Expression for pin";
  eff=wh/pin"Expression for eff";
  annotation(experiment(StartTime = 0, StopTime = 6000, Tolerance = 1e-06, Interval = 12));
end Ex10_4;
