//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-10 : Fluid machinery
//Example: 10.7   Page:527
//Topic: Calculation of NPSH
//===================================================================================
model Ex10_7

//============================================================
//Parameter Section
parameter Real d(unit="m")=0.128"Diameter of the pipe";
parameter Real l(unit="m")=1.8"Length of pipe";
parameter Real q(unit="m^3/hr")=230"Flowrate";
parameter Real kv(unit="m^2/s")=8.03E-7"KInematic Viscosity";
parameter Real me(unit="")=0.5"Minor loss coefficient for entrance";
parameter Real mse(unit="")=30"Minor loss coefficient for atandard elbow ";
parameter Real mo(unit="")=8"MInor loss coeffficient for standard open gate valve";
parameter Real patm(unit="Pa")=101325"Atmospheric pressure";
parameter Real p(unit="kg/m^3")=996"Density of water";
parameter Real g(unit="m^2/s")=9.81"Accelerartion due to gravity";
parameter Real hv(unit="m")=0.44"Vapor pressure in terms of head of water";
parameter Real f(unit="")=0.0237"Friction Factor";
parameter Real c1(unit="hr/s")=1/3600"Unit conversion constant";
parameter Real c2(unit="kg/(Pa*s^2*m)")=1"Unit converion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//============================================================
//Variable Section
Real a(unit="m^2")"Area";
Real vs(unit="m/s")"Velocity of water";
Real s(unit="")"Summation of all minor losses";
Real h1(unit="m")"Head due to static pressure";
Real hd(unit="m")"Head due to dynamic pressure";
Real hs(unit="m")"Head due to suction pressure";
Real npsha(unit="m")"Net positive suction head available";

//============================================================
//Equation Section
equation
a=0.25*pi*d^2"Ëxpression for a";
vs=q*c1/a"Expression for vs";
s=me+(f*(mse+mo))+(f*l/d)+1"Expression for s";
h1=patm*c2/(p*g)"Experssion for head";
hd=vs^2/(2*g)"Expression for hd";
hs=h1+1-(s*hd)"Expresion for hs";
npsha=hs-hv+(vs^2/(2*g))"Expression for npsha";
end Ex10_7;
//===============================================================
