model Ex12_1
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-12 : Introduction to compressible flow
  //Example: 12.1   Page:663
  //Topic: Property changes in duct flow
  //=======================================================================
  //=======================================================
  //Parameter Section
  parameter Real p1(unit = "kPa") = 188 "Absolute pressure in zone-1";
  parameter Real t1(unit = "K") = 440 "Temperature of air in zone-1";
  parameter Real v1(unit = "m/s") = 210 "Velocity of air in zone-1";
  parameter Real p2(unit = "kPa") = 213 "Absolute pressure in zone-2";
  parameter Real t2(unit = "K") = 351 "Temperature of air in zone-2";
  parameter Real R(unit = "N*m/(kg*K)") = 287 "Universal gas constant";
  parameter Real m(unit = "kg/s") = 0.15 "Mass flow rate of gas";
  parameter Real cp(unit = "kJ/(kg*K)") = 1 "Specific heat capacity at constant pressure";
  parameter Real cv(unit = "kJ/(kg*m)") = 0.717 "Specific heat capacity at constant volume";
  parameter Real c1(unit = "N/(m^2*kPa)") = 10 ^ 3 "Unit conversion constant";
  //=======================================================
  //Variable Section
  Real d1(unit = "kg/m^3") "Density at zone-1";
  Real a(unit = "m^2") "Area of cross section";
  Real delh(unit = "kJ/kg") "Change in enthalpy";
  Real delu(unit = "kJ/kg") "Change in internal energy";
  Real dels(unit = "kJ/(kg*K)") "Change in entropy";
  //=======================================================
  //Equation Section
equation
  d1 = p1 * c1 / (R * t1) "Expression for d1";
  a = m / (d1 * v1) "Expression for cross sectional area";
  delh = cp * (t2 - t1) "Expression for change in enthalpy";
  delu = cv * (t2 - t1) "Expression  for change in internal energy";
  dels = cp * log(t2 / t1) - (R * log(p2 / p1)/1000) "Expression for change in entropy";
  annotation(experiment(StartTime = 0, StopTime = 6000, Tolerance = 1e-06, Interval = 12));
end Ex12_1;
