//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-12 : Introduction to compressible flow
//Example: 12.4   Page:672
//Topic: Mach cone of a bullet
//=======================================================================
model Ex12_4

//=======================================================
//Parameter Section
parameter Real k(unit="")=1.4"Constant ";
parameter Real R(unit="N*m/(kg*K)")=287"Universal gas constant ";
parameter Real t(unit="K")=288"Temperature";
parameter Real v(unit="m/s")=550"Speed of bullet";
parameter Real h(unit="m")=5"Perpendicular height of camera from object";
parameter Real ti(unit="s")=0.005"Delay time";
parameter Real c1(unit="kg*m/(N*s^2)")=1"Unit conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real c(unit="m/s")"Speed of sound at NTP";
Real m(unit="")"Mach number";
Real a(unit="")"Mach angle in degrees";
Real x(unit="m")"Distance travelled by bullet";
Real d(unit="m")"Actual distance travelled by bullet"; 

//=======================================================
//Equation Section
equation
c=sqrt(k*R*t*c1)"Expresssion for velocity of sound ";
m=v/c"Expression for mach number";
a=(asin(1/m))*180/pi"mach angle in angle";
x=h/tan(a)"Expresion for x";
d=x+(ti*v)"Expression for d";
end Ex12_4;
//=====================================================================
