//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015 
//Chapter-2 : Fundamental Concepts
//Example: 2.2   Page 20
//Topic: Viscosity and Shear Stress
//=======================================================================
model Ex2_2


//======================================================
// Parameter Section
parameter Real v1(unit="g/(cm*s)")=6.5E-3"Viscosity in g/(cm*s)";
parameter Real u(unit="m/s")=0.3"Velocity of plate";
parameter Real d(unit="m")=0.3E-3"Distance between plates";
parameter Real sg(unit="")=0.88"Specific Gravity";
parameter Real pw(unit="kg/m^3")=1000"Density of water";
parameter Real c1(unit="kg*m/(g*s^2)")=9.81E-3"Conversion Factor"; 
parameter Real c2(unit="m^2/(cm*s)")=9.81E-2"Conversion Factor";  
parameter Real c3(unit="N/(kg*m/s^2)")=1"Conversion Factor ";

//======================================================
// Variable Section
Real v2(unit="N*s/m^2")"Viscosity in kg/(m*s)";
Real kv(unit="m^2/s")"Kinematic Viscosity in m^2/s"; 
Real sh1(unit="N/m^2")"Shear Stress on Upper Plate";
Real sh2(unit="N/m^2")"Shear Stress on Lower Plate";

//======================================================
// Equation Section
equation
v1*c1/c2*c3=v2"Absolute Viscosity in N.s/m^2";
kv=v2*c3/(sg*pw)"Kinematic Viscosity in m^2/s";
sh1=v2*u/d"Shear Stress on Upper Plate in N/m^2";
sh2=sh1"Shear Stress on Lower Plate in N/m^2";
end Ex2_2;
//======================================================
