//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  

//Chapter-3 : Pressure Variation in a Static Fluid
//Example: 3.8   Page:81
//Topic: Buoyancy force in a hot air balloon
//=======================================================================
model Ex3_8

//==============================================================
//Parameter Section
parameter Real d(unit="m")=15"Diamter of the balloon";
parameter Real l(unit="N")=2670"Basket Load of the balloon";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real p1(unit="kg/m^3")=1.227"Density of air at one atmosphere pressure";
parameter Real t1(unit="K")=288"Temperature at one atmosphere pressure ";
parameter Real c(unit="kg*m/(N*s^2)")=1;
final constant Real pi=2*Modelica.Math.asin(1.0);
//==============================================================
//Variable Section
Real p2(unit="kg/m^3")"Density of hot air";
Real t2(unit="K")"Temperature of hot air";

//===================================================================
equation
p2=p1-(6*l*c/(pi*d^3*g))"Expression for Evaluating density of hot air";
t2=t1*p1/p2"Expression for Evaluating temperature of hot air";
end Ex3_8;
//==============================================================================
