//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.14   Page:137
//Topic: Lawn Sprinkler: Analysis using fixed control volume 
//=======================================================================
model Ex4_14
//=======================================================
//Parameter Section
parameter Real q(unit="l/min")=7.5"Total flow rate of water";
parameter Real D(unit="mm")=4"Diameter of each jet";
parameter Real c1(unit="m^3/l")=1E-3"Unit conversion constant";
parameter Real c2(unit="m/mm")=1E3"Unit conversion constant";
parameter Real s(unit="rev/min")=30"Speed with which sprinkler rotates";
parameter Real r(unit="mm")=150"Diameter of the Sprinkler";
parameter Real a(unit="")=30"Angle";
parameter Real c3(unit="rad/rev")=2"Unit Conversion constant";
parameter Real c4(unit="min/sec")=1/60"Unit Conversion constant";
parameter Real c5(unit="N*s^2/(kg*m)")=1"Unit Conversion constant";
parameter Real p(unit="kg/m^3")=999"Density of water";
final constant Real pi=2*Modelica.Math.asin(1.0);
final constant Real D2R=pi/180 "Degree to Radian";
//=======================================================
//Varaible Section
Real wr(unit="m/s")"Angular Velocity";
Real vr(unit="m/s")"Relative Jet Speed";
Real tq(unit="N*m")"Friction Torque";

//=======================================================
//Equation Section
equation
vr=q*4*c4*c1/(2*pi*c2^(-2)*D^2)"Expression for Relative jet speed";
wr=s*r*c3*pi*c4*c1"Expresssion for angular velocity";
tq=r*(vr*cos(a*D2R)-wr)*p*q*c1*c4*c5/c2"Expression for Friction torque";
end Ex4_14;
//===================================================================
