//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.16   Page:143
//Topic: Compressor first  law analysis 
//=======================================================================
model Ex4_16

//=======================================================
//Parameter Section
parameter Real p1(unit="kPa")=101"Presure at section-1";
parameter Real p2(unit="kPa")=344"Pressure at section-2";
parameter Real v1(unit="m/s")=0"Velocity of air at section-1";
parameter Real t1(unit="K")=(21+273)"Temperature at section-1";
parameter Real t2(unit="K")=(273+38)"Temperature at section-2";
parameter Real a2(unit="m^2")=0.09"Area of cross section in section-2";
parameter Real ma(unit="kg/s")=9"Mass flow rate of air";
parameter Real pi(unit="kW")=447"Power input to the compressor";
parameter Real c1(unit="kPa/Pa")=1E3"Unit converision constant";
parameter Real c2(unit="N/(Pa*m^2)")=1"Unit conversion constant";
parameter Real c3(unit="N*m/J")=1"Unit conversion constant";
parameter Real c4(unit="N*s^2/(kg*m)")=1"Unit conversion constant";
parameter Real c5(unit="W*s/(N*m)")=1"Unit conversion constant";
parameter Real c6(unit="kW/W")=1E3"Unit conversion constant";
parameter Real R(unit="J/(kg*K)")=287"Universal gas constant";
parameter Real cp(unit="J/(kg*K)")=1005"Specific heat of air";
//=======================================================
//Variable Section
Real v2(unit="m/s")"Velocity of air at section-2";
Real q(unit="kW")"Heat Rejection";

//=======================================================
//Equation Section 
equation
v2=ma*R*t2*c3/(a2*p2*c1*c2)"Expression for velocity of air at section-2";
q=-pi+(ma*v2^2*0.5*c4*c5/c6)+(ma*cp*(t2-t1)*c3*c5/c6)"Expression for Heat rejection";
end Ex4_16;
//=================================================================================
