//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.17   Page:144
//Topic: Tank Filling: First law analysis 
//=======================================================================
model Ex4_17

//=======================================================
//Parameter Section
parameter Real p1(unit="MPa")=20"Pressure of high pressure line";
parameter Real p2(unit="kPa")=100"Pressure in tank ";
parameter Real t(unit="K")=(273+20)"Temperature";
parameter Real v(unit="m^3")=0.1"Volume of tank";
parameter Real R(unit="N*m/(kg*K)")=287"Universal gas constant";
parameter Real cv(unit="N*m/(kg*K)")=717"Control volume";
parameter Real dTt(unit="K/s")=0.05"Temperature Gradient";
parameter Real patm(unit="N/m^2")=1.01"Atmospheric Pressure";
parameter Real c1(unit="g/kg")=1E3"Unit Conversion constant";
parameter Real c2(unit="m^2*kPa/N")=100"Unit Conversion constant";

//=======================================================
//Variable Section
Real d(unit="kg/m^3")"Density of air in tank";
Real m(unit="g/s")"mass flow rate of air ";
//=======================================================
//Equation Section
equation
d=((p2/c2)+patm)*1E5/(R*t)"Expression for Density of air in tank";
m=d*v*cv*dTt*c1/(R*t)"Expression for mass flow rate of air";
end Ex4_17;
//======================================================================
