//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  

//Chapter-4 : Basic equations in integral form for a control volume
//Example: 4.6   Page:117
//Topic: Flow through elbow: use of gage pressures
//=======================================================================
model Ex4_6

//==============================================================
//Parameter Section

parameter Real p1(unit="kPa")=220"Pressure in inlet to elbow";
parameter Real a1(unit="m^2")=0.01"Cross sectional area at the inlet of the elbow";
parameter Real a2(unit="m^2")=0.0025"Cross sectional area of the outlet of the elbow";
parameter Real v2(unit="m/s")=16"Velocity of water at the outlet of the elbow";
parameter Real d(unit="kg/m^3")=999"Density of water";
parameter Real patm(unit="kPa")=101"Atmospheric pressure";
parameter Real c1(unit="kN/(m^2*kPa)")=1"Unit conversion factor";
parameter Real c2(unit="kN*s/(kg*m)")=1E-3"Unit conversion factor";
parameter Real c3(unit="N*s/(kg*m)")=1"Unit conversion constant";
//==============================================================
//Variable Section
Real v1(unit="m/s")"Velocity of water in the elbow inlet ";
Real rx(unit="kN")"Horizontal force required to hold the elbow";
Real ry(unit="N")"Vertical force required to hold the elbow";

//===============================================================
//Equation section
equation
rx=-1*(((p1-patm)*a1*c1)+(d*v1^2*a1*c2))"Expression for horizontal force to hold the elbow";
v1=a2*v2/a1"Expression for evaluating velocity in the inlet of the elbow";
ry=-1*d*v2^2*a2*c3"Expression for vertical force to hold the elbow";

end Ex4_6;
