//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-6 : Incompressible invisid flow
//Example: 6.1   Page:240
//Topic: Flow in a bend 
//=======================================================================
model Ex6_1

//=======================================================
//Parameter Section
parameter Real r1(unit="m")=0.25"Inner radius of bend";
parameter Real w(unit="m")=0.1"Width of the duct";
parameter Real delh(unit="m")=0.04"Difference between taps";
parameter Real da(unit="kg/m^3")=1.23"Density of air";
parameter Real dw(unit="kg/m^3")=999"Density of Water";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real t(unit="m")=0.3"Depth of duct";

//=======================================================
//Variable Section
Real v(unit="m/s")"Velocity of air";
Real p21(unit="kg/(m*s^2)")"Pressure difference between taps";
Real q(unit="m^3/s")"Volumetric flow rate of air";
Real r2(unit="m")"Outer radius of the bend";
//=======================================================
//Equation Section
equation
p21=dw*g*delh"Expression for p21";
v=sqrt(p21/(da*log(r2/r1)))"Expression for v";
r2=r1+w"Expression for Outer radius of the bend";
q=v*t*w"Expression for volumetric flowrate";
end Ex6_1;
//============================================================
