//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-6 : Incompressible invisid flow
//Example: 6.4   Page:248
//Topic: Flow through siphon 
//=======================================================================
model Ex6_4

//=======================================================
//Parameter Section
parameter Real p1(unit="N/m^2")=1.01E5"Pressure at point-1";
parameter Real z1(unit="m")=1"Distance between point-1 and point-a";
parameter Real z2(unit="m")=8"Distance between point-2 and point-a";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real d(unit="kg/m^3")=999"Density of water";
parameter Real za(unit="m")=-1"Height of point a from reference level";
parameter Real c1(unit="N*s^2/(kg*m)")=1"Unit conversation constant";
parameter Real c2(unit="kPa*m^2/N")=1E-3"Unit conversion constant";

//=======================================================
//Variable Section
Real v2(unit="m/s")"Velocity at point-2";
Real pa(unit="kPa")"Pressure  at point-a";

//=======================================================
//Equation Section
equation
v2=sqrt(2*g*(z2-z1))"Velocity at point-2";
pa=(p1*c2)+(d*g*za*c2*c1)-(0.5*d*v2^2*c1*c2)"Expression for pressure at point-a";
end Ex6_4;
//==========================================================================
//Remark
//The obtained answer is 22.598, this is because of rounding off error
