//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-6 : Incompressible invisid flow
//Example: 6.6   Page:251
//Topic: Bernoulli equation in translating reference frame  
//=======================================================================
model Ex6_6
//=======================================================
//Parameter Section
parameter Real patm(unit="N/m^2")=1.01E5"Atmospheric Pressure at sea level";
parameter Real do(unit="kg/m^3")=1.23"Density at sea level";
parameter Real rp(unit="")=0.8870"Ratio of pressures at 1000m altitude and sea level from table A.3";
parameter Real rd(unit="")=0.9075"Ratio of density at 1000m altitude and sea level from table A.3 ";
parameter Real g(unit="m/s^2")=9.81"Accelerarion due to gravity";
parameter Real va(unit="km/hr")=150"Velocity of air";
parameter Real vb(unit="m/s")=60"Velocity at point-B";
parameter Real c1(unit="km*s/(m*hr)")=3.6"Unit conversion constant";
parameter Real c2(unit="N*s^2/(kg*m)")=1"unit conversion constant";
parameter Real c3(unit="kPa*m^2/N")=1E-3"unit conversion constant";
//=======================================================
//Variable Section
Real poa(unit="kPa")"Stagnation pressure at the leading edge of the wing";
Real pb(unit="kPa")"Pressure at point-B";
Real p(unit="N/m^2")"Pressure at 1000m altitude";
Real d(unit="kg/m^3")"Density at 1000m altitude";

//=======================================================
//Equation Section
equation
p=rp*patm"Expression for pressure at  1000m altitude";
d=rd*do"Expression for density at 1000m altitude";
poa=(p+(0.5*d*(va/c1)^2*c2))*c3"Expression for Stagnation pressure";
pb=(p+(0.5*d*((va/c1)^2-vb^2)*c2))*c3"Expression fro pressure at point-B";
end Ex6_6;
//========================================================================
