//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-7 : Dimensional analysis and simlitude
//Example: 7.6   Page:316
//Topic: Pump laws
//=======================================================================
model Ex7_6

//=======================================================
//Parameter Section
parameter Real q1(unit="m^3/s")=68"Pump flow rate of motor-1";
parameter Real w1(unit="rpm")=1170"Rated rpm of motor-1";
parameter Real w2(unit="rpm")=1750"Rated rpm of motor-2 ";
parameter Real d1(unit="m")=200E-1"Impeller Diameter of motor-1";
parameter Real d2(unit="m")=200E-1"Impeller Diameter of motor-2";
parameter Real n(unit="")=0.8"Efficiency of the motor";
parameter Real p1(unit="kg/m^3")=1000"Density of water flowing in motor-1";
parameter Real p2(unit="kg/m^3")=1000"Density of water flowing in motor-2";
parameter Real ns(unit="")=2323"Specific speed ";
parameter Real g(unit="m/s^2")=9.81"Universal gractitation constant";
parameter Real c1(unit="hr/min")=1/60"Unit conversion constant";
parameter Real c2(unit="min/s")=1/60"Unit conversion constant";
parameter Real c3(unit="kW*s^3/(kg*m^2)")=1E-3"Unit conversion constant";

//=======================================================
//Variable Section
Real q2(unit="m^3/s")"Pump flow rate for motor-2";
Real h1(unit="m")"Pump head of motor-1";
Real h2(unit="m")"Pump head of motor-2";
Real po1(unit="kW")"Output power of the pump of motor-1";
Real po2(unit="kW")"Output power of the pump of motor-2";
Real ns1(unit="")"Specififc speed of motor";
Real pin(unit="kW")"Required power input";
//=======================================================
//Equation Section
equation
q2=q1*(w2/w1)*(d2/d1)^2"Expression for q2";
h1=(w1*q1^0.5/ns)^(4/3)"Expression for h1";
h2=h1*(w2/w1)^2*(d2/d1)^2"Expression for h2";
po1=p1*g*q1*h1*c1*c2*c3"Expression for p01";
po2=po1*(p2/p1)*(w2/w1)^3*(d2/d1)^5"Expression for po2";
pin=po2/n"Expression for power input";
ns1=w2*q2^0.5/h2^0.75"Expression for ns2";
end Ex7_6;
//==========================================================
