model Ex8_12
  //Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015
  //Chapter-8 : Internal incompressible viscous flow
  //Example: 8.12   Page:395
  //Topic: Flow through an orifice meter
  //=======================================================================
  //=======================================================
  //Parameter Section
  parameter Real q(unit = "m^3/s") = 1 "Flowrate of air";
  parameter Real d1(unit = "m") = 0.25 "Diameter in section-1";
  parameter Real p(unit = "kg/m^3") = 1.23 "Density of air";
  parameter Real pw(unit = "kg/m^3") = 999 "Density of water";
  parameter Real h(unit = "m") = 0.3 "Manometric head";
  parameter Real g(unit = "m/s^2") = 9.81 "Acceleration due to gravity";
  parameter Real b(unit = "") = 0.66 "Diameter Ratio from fig 8.21";
  parameter Real n(unit = "m^2/s") = 1.46E-5 "Kinematic viscosity";
  parameter Real c1(unit = "N*s^2/(kg*m)") = 1 "Unit conversion constant";
  final constant Real pi = 2 * Modelica.Math.asin(1.0);
  //=======================================================
  //Variable Section
  Real re(unit = "") "Reynolds number associated with the flow of fluid";
  Real k(unit = "") "Loss coefficient";
  Real dt(unit = "m") "Diameter of orifice plate";
  Real p23(unit = "N/m^2") "Pressure difference between sections 2 and 3";
  Real p12(unit = "N/m^2") "Pressure difference between sections 1 and 2";
  Real hl(unit = "N*m/kg");
  Real pf(unit = "");
  //=======================================================
  //Equation Section
equation
  k * b ^ 2 = q * sqrt(p / (2 * pw * g * h)) * 4 / (pi * d1 ^ 2) "Expression for kb^2";
  dt = b * d1 "Expression for dt";
  p23 = p*c1*q^2*(((0.65*b^2)^(-1))-1)/((0.25*pi)^2*d1^4) "Expression for p23";
  p12 = pw * g * h * c1 "Expresion for p12";
  hl = (p12 - p23) / p "Expression for hl";
  pf = (p12 - p23) / p12 "Expression for pf";
  re = 4 * q / (pi * n * d1) "Expression for reynolds number";
  annotation(experiment(StartTime = 0, StopTime = 6000, Tolerance = 1e-06, Interval = 12));
end Ex8_12;
