//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-8 : Internal incompressible viscous flow
//Example: 8.4   Page:347
//Topic: Capillary Viscometer
//=======================================================================
model Ex8_4

//=======================================================
//Parameter Section
parameter Real q(unit="mm^3/s")=880"Flow rate";
parameter Real l(unit="m")=1"Tube length";
parameter Real d(unit="mm")=0.5"Diameter of tube";
parameter Real delp(unit="N/m^2")=1E6"Pressure drop";
parameter Real c1(unit="m/mm")=1E-3"Unit Conversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);
//=======================================================
//variable Section
Real m(unit="N*s/m^2")"Visosity of the fluid";
Real v(unit="m/s")"Velocity of the fluid";

//=======================================================
//Equation Section
equation
v=4*q*c1/(pi*d^2)"Expression for velocity";
m=pi*delp*d^4*c1/(128*l*q)"Expression for viscosity";
end Ex8_4;
//===================================================================
