//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-8 : Internal incompressible viscous flow
//Example: 8.5   Page:372
//Topic: Pipe flow into a reservoir: pressure drop unknown
//=======================================================================
model Ex8_5

//=======================================================
//Parameter Section
parameter Real q(unit="m^3/s")=0.01"Flow rate of water";
parameter Real d(unit="m")=0.075"Diameter of the  pipe connecting tank and pump";
parameter Real p(unit="kg/m^3")=999"Density of water";
parameter Real m(unit="Kg/(m*s)")=1E-3"Viscosity of water";
parameter Real e(unit="")=0"Roughness factor of pipe";
parameter Real g(unit="m/s^2")=9.81"Universal gravitational constant";
parameter Real l(unit="m")=100"Length of the pipe";
parameter Real h(unit="m")=10"Height of water level in tank from pump level";
parameter Real c1(unit="N*s^2/(kg*m)")=1"Unit conversion constant";
parameter Real c2(unit="kPa*m^2/N")=1E-3"Unit onversion constant";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real v(unit="m/s")"Velocity of water in pipe";
Real re(unit="")"Reynolds number";
Real f(unit="")"Roughness Factor";
Real pp(unit="kPa")"Pressure produced by pump";


//=======================================================
//Equation Section
equation
v=4*q/(pi*d^2)"Expression for velocity";
re=p*v*d/m"Expresion for reynolds number";
pp=p*((g*h)+(f*l*0.5*v^2/d))*c1*c2"Expression for power";
1/sqrt(f)=-2*log10((e/(d*3.7))+(2.51/(re*sqrt(f))))"Expresion for evaluating friction factor";
end Ex8_5;
//====================================================================================================
