//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-8 : Internal incompressible viscous flow
//Example: 8.6   Page:373
//Topic: Flow in a pipeline:length unknown
//=======================================================================
model Ex8_6

//=======================================================
//Parameter Section
parameter Real q(unit="m^3/s")=2.944"Flowrate thorugh pipe";
parameter Real d(unit="m")=1.22"Diameter of the pipe";
parameter Real p(unit="kg/m^3")=1000"Density of water";
parameter Real m(unit="N*s/m^2")=0.0168"Viscosity of water";
parameter Real e(unit="m")=0.00015"Roughness factor of pipe";
parameter Real p1(unit="Pa")=8.27E6"Pressure at pump end of the pipeline";
parameter Real p2(unit="Pa")=3.445E5"Pressure at the open end of the pipe";
parameter Real sg(unit="")=0.93"Specific gravity of fluid flowing";
parameter Real c1(unit="MW*s/(m^3*Pa)")=1E-6"Unit converison constant";
parameter Real n(unit="")=0.85"Efficiency of pump";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real v(unit="m/s")"Velocity of fluid";
Real re(unit="")"Reynolds number for associated with the flow";
Real l(unit="m")"Lengthof the pipe";
Real wpi(unit="MW")"Power reaching the fluid";
Real win(unit="MW")"Power input";
Real f(unit="")"Friction Factor";

//=======================================================
//Equation Section
equation
v=4*q/(pi*d^2)"Expression for velocity";
re=p*sg*v*d/m"Expresion for reynolds number";
1/sqrt(f)=-2*log10((e/(d*3.7))+(2.51/(re*sqrt(f))))"Expresion for evaluating friction factor";
(p1-p2)=f*l*v^2*p*sg*0.5/d"Expression for length";
wpi=q*(p1-p2)*c1"Expression for wpi";
win=wpi/n"Expresion for power input";
end Ex8_6;
//==================================================================
