//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-8 : Internal incompressible viscous flow
//Example: 8.9   Page:379
//Topic: Calculation of entrance loss coefficient
//=======================================================================
model Ex8_9

//=======================================================
//Parameter Section
parameter Real q(unit="m^3/s")=0.016"Flow rate of water";
parameter Real g(unit="m/s^2")=9.81"Acceleration due to gravity";
parameter Real d(unit="m")=38E-3"Diameter of the pipe ";
parameter Real nu(unit="m^2/s")=9.75E-7"Kinematic viscosity";
parameter Real v1(unit="m/s")=0;
parameter Real ed(unit="")=0.00004"Roughness factor";
parameter Real l(unit="m")=3"Length of the pipe";
parameter Real h(unit="m")=25.9"Height of tank";
final constant Real pi=2*Modelica.Math.asin(1.0);

//=======================================================
//Variable Section
Real v2(unit="m/s")"Velocity at point-2";
Real re(unit="")"Reynolds number for the flow";
Real a(unit="")"kinetic energy correction factor";
Real n(unit="")"Turbulent power law coeffcient";
Real vu(unit="")"ratio of v/u";
Real k(unit="")"Entrance loss coefficient";
Real f(unit="")"Friction factor";
//=======================================================
//Equation Section
equation
v2=4*q/(pi*d^2)"Expresion for velocity at point-2";
re=v2*d/nu"Expression for Reynolds number";
1/sqrt(f)=-2*log10((ed/3.7)+(2.51/(re*sqrt(f))))"Expresion for evaluating friction factor";
vu=(2*n^2/((n+1)*((2*n)+1)))"Expression for v/u ratio";
a=vu^(-3)*(2*n^2)/((3+n)*(3+(2*n)))"Expression for kinetic energy correction factor";
n=(-1.7)+(1.8*log10(re))"Expression for turbulent power law coefficient";
k=(2*g*h/v2^2)-(f*l/d)-a"Ëxpression fro entrance loss coefficient";
end Ex8_9;
//======================================================================================
