//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-9 : External incompressible flow
//Example: 9.5   Page:449
//Topic: Skin frction drag on a supertanker
//================================================================
model Ex9_5

//=======================================================
//Parameter Section
parameter Real l(unit="m")=360"Length of supertanker";
parameter Real b(unit="m")=70"Breadth of supertanker";
parameter Real d(unit="m")=25"Depth of supertanker";
parameter Real u(unit="m/s")=6.69"Crusing Speed";
parameter Real v(unit="m^2/s")=1.37E-6"Kinematic viscosity";
parameter Real p(unit="kg/m^3")=1020"Density of seawater ";
parameter Real c1(unit="N*s^2/(kg*m)")=1"Unit conversion constant";
parameter Real c2(unit="MN/N")=1E-6"Unit conversion constant";
parameter Real c3(unit="W*s/(N*m)")=1"Unit conversion constant";
parameter Real c4(unit="MW/W")=1E-6"Unit conversion constant";
//=======================================================
//Variable Section
Real cd(unit="")"Skin friction coefficient";
Real rel(unit="")"Reynolds number";
Real fd(unit="MN")"Drag force";
Real po(unit="MW")"Power";

//=======================================================
//Equation Section
equation
rel=u*l/v"Expression for Reynolds number";
cd=(0.455/(log10(rel))^(2.58))-(1610/(rel))"Expression for Skin friction coefficient";
fd=cd*0.5*l*(b+(2*d))*p*u^2*c1*c2"Expression for Drag force ";
po=fd*u*c3*c4/c2"Expression for power";
end Ex9_5;
//==============================================================
