//Fox R. W., McDonald A. T.,& Pritchard P. J. Fluid Mechanics,8th Edition, Wiley India Pvt. Ltd., 2015  
//Chapter-9 : External incompressible flow
//Example: 9.6   Page:454
//Topic: Aerodynamic drag and moment on a chimney
//================================================================
model Ex9_6
//=======================================================
//Parameter Section
parameter Real l(unit="m")=25"Height of the chimney";
parameter Real d(unit="m")=1"Diameter of the chimney";
parameter Real v(unit="km/hr")=50"Velocity of air";
parameter Real P(unit="kPa")=101"Pressure of air";
parameter Real t(unit="C")=15"Temperature of air";
parameter Real cd(unit="")=0.35"Skin friction coefficient";
parameter Real p(unit="kg/m^3")=1.23"Density of air";
parameter Real m(unit="kg/(m*s)")=1.79E-5"Viscosity of air";
parameter Real c1(unit="km*s/(m*hr)")=3.6"Unit conversion constant";
parameter Real c2(unit="N*s^2/(kg*m)")=1"Unit converison constant";
parameter Real c3(unit="kN/N")=1E-3"Unit conversion constant";

//=======================================================
//Variable Section
Real re(unit="")"Reynolds number";
Real mo(unit="kN*m")"Bending moment at the base of the chimney";

//=======================================================
//Equation Section
equation
re=p*v*d/(m*c1)"Expression for reynolds number";
mo=cd*d*l^2*p*((v/c1)^2)*0.25*c2*c3"Expression for bending moment";
end Ex9_6;
//=======================================================
