model Ex10_9
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A 'long' steel shaft of 10 cm diameter is austenised at 870 C and then quenched in a liquid at 30 C. The average surface heat transfer coefficient is 2000 W/m^ C. The relevent thermophysical properties of the shaft material are k=20 W/m C; density=7800 Kg/m^3; Cp=0.46 KJ/Kg C. Calculate<div>(i) The time required for the centre-line temperature to drop down to 200 C (martensite forums at this temperature)</div><div>(ii) The temperature at half-radius at that moment</div><div>(iii) The amount of heat that has been transfered to the liquid by that time per meter length of the shaft</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real Ti(unit="C")=870"Initial temperature";
parameter Real To(unit="C")=30"Ambient temperature";
parameter Real Tc(unit="C")=200"Centre line temperature";
parameter Real h(unit="W/m^2 C")=2000"Heat transfer coefficient";
parameter Real a(unit="m")=0.05"Radius of the cylinder";
parameter Real ro(unit="Kg/m^3")=7800"Density of shaft";
parameter Real Cp(unit="J/Kg C")=460"Specific heat of shaft";
parameter Real k(unit="W/m C")=20"Thermal conductivity of shaft";
parameter Real l(unit="m")=1"Length of the shaft";
Real Tc_bar;
Real Bi"Biot Number";
Real alpha(unit="m^2/s")"Thermal diffusivity";
Real T(unit="C")"temperature at half-radius";
Real Fo"Fourier Number";
Real Bi_2_Fo"Product of Fourier No and square of Bi";
Real t(unit="s")"Time required";
Real Qi(unit="KJ")"Initial amount of heat present";
Real Q(unit="KJ")"Amount of heat present after t sec";
equation
Tc_bar=((Tc-To)/(Ti-To));
Bi=((h*a)/(k));
alpha=((k)/(ro*Cp));
//Sub division (i)
Fo=(alpha*t/(a^2));
Fo=0.51; // 0.51 is taken from fig 10.7(a)
//Sub division (ii)
((T-To)/(Tc-To))=0.77; //0.77 is taken from fig 10.7(a)
//Sub division (iii)
Bi_2_Fo=((Bi^2)*Fo);
Qi=((pi*(a^2)*l*ro)*((Cp/1000)*(Ti-To)));
(Q/Qi)=0.83;  // 0.83 is taken from fig 10.9 (b)
//Due to the approximation in the book calculation, there is a slight difference in the simulated result with the book ans
end Ex10_9;
