model Ex11_1
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>What at 25C flows at a velocity of 1m/s on both sides of a flat plate, 1m long 0.5 m wide, at zero angle of incidence. Calculate<div>(i) The boundary layer thickness midway of the plate, at x=0.5 m,</div><div>(ii) The local drag coefficient at x=0.5 m</div><div>(iii) The force required to hold the plate in position</div><div>(iv) the shear stress at a plane, distane delta/2 from the surface at x=0.5 m</div></body></html>"));
//Data are given in the problem statement
parameter Real T(unit="C")=25"Temperature of water";
parameter Real ki_vis(unit="m^2/s")=8.63*10^(-7)"Kinamatic viscosity";
parameter Real v(unit="m/s")=1"Velocity of water";
parameter Real L(unit="m")=1"length of plate";
parameter Real w(unit="m")=0.5"Wide of plate";
parameter Real x(unit="m")=0.5"Given distance";
parameter Real vis(unit="Kg/m S")=8.6*10^(-4)"Viscosity of water";
parameter Real f_eta=0.218"value of eta function";
Real Rex"Local reynolds number at x";
Real delta_x(unit="mm")"Thickness of boundary layer at x";
Real Cd_x"Drag coefficient at x";
Real Fd(unit="N")"Force required to hold the plate";
Real Rel"Reynolds number at end";
Real eta"value of eta at x=(delta/2)";
Real SS(unit="N/m^2")"Shear stess at delta/2";
equation
//Subdivision (a)
Rex=((v*x)/(ki_vis));
delta_x=(5*(x/(Rex^(1/2))))*1000;
//Subdivision (b)
Cd_x=((0.332*(Rex^(-1/2)))/((1/2))); //There are some terms in numerator and denominator, that are get cancelled
//Subdivision (c)
Rel=((L*v)/(ki_vis));
Fd=(0.664*(vis)*(v)*(Rel^(1/2))*(w));
//Subdivision (d)
eta=(((delta_x/1000)/2)/((ki_vis*x/v)^(1/2)));
SS=(vis*v*((v/(ki_vis*x))^(1/2))*f_eta);
//Due to the approximation in the calculation in the book, there is slight difference in the simulated value with the book ans
end Ex11_1;
