model Ex11_4
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Air at 25 C flows over both sides of a 0.4*0.3 m copper plate, 25.4 mm thick (density=8880 Kg/m^3; Specific heat =0.385 KJ/Kg K). If the air velocity is 1 m/s and the plate temperature is assumed to remain uniform (in view of the high thermal conductivity of copper), Calculate the temperature of the plate after 1 hour if its initial temperature is 120 C.</body></html>"));
parameter Real Ta(unit="C")=25"Air temperature";
parameter Real Ti(unit="C")=120"Initial temperature of copper";
parameter Real ki_vis(unit="m^2/s")=2.07*10^(-5)"Kinamatic viscosity of air";
parameter Real Pr=0.7"Prandtl Number of air";
parameter Real k(unit="W/m C")=0.03"Thermal conductivity of air";
parameter Real v(unit="m/s")=1"Velocity of air";
parameter Real L(unit="m")=0.4"Length of the plates";
parameter Real w(unit="m")=0.3"width of the plate";
parameter Real thick(unit="m")=0.0254"Thickness of plate";
parameter Real dt(unit="s")=10"step size";
parameter Real density(unit="Kg/m^3")=8880"Density of plate";
parameter Real Cp(unit="J/Kg K")=385"Specific heat of plate";
Real Tf(unit="C")"Mean temperature";
Real Rel"Local Reynolds Number";
Real hav(unit="W/m^2 C")"Local heat transfer coefficient";
Real[361] T(unit="C")"Temperature of plate at any time";
Real[361] t(unit="h")"Time of heat transfer";
Real T_1(unit="C")"Temperature of plate after 1 h";
equation
Tf=((Ti+Ta)/2);
Rel=((L*v)/ki_vis);
((hav*L)/k)=(0.664*(Rel^(1/2))*(Pr^(1/3)));
//Calculation of temperature by using forward difference calculation
//Initial condition
T[1]=Ti;
t[1]=0;
for i in 1:360 loop
T[i+1]=((-1)*((((2*L*w)*hav*(T[i]-Ta))*dt)/(density*(L*w*thick)*Cp)))+T[i];
t[i+1]=t[i]+(dt/3600);
end for;
T_1=(T[361]);
end Ex11_4;
