model Ex2_4
  annotation(
    Documentation(info = "<html><head></head><body>A tapered stainless steel rod, Perfectly insulated on the curved surface, has end diameters of 0.06m and 0.12 m respectively, and is 0.2 m long. The thicker end is fixed to a hot wall and the thinner end is maintained at 30 C. The steady state rate of heat loss through the end is found to be 50 W. The thermal conductivity of stainless steel is 15 W/m C. Calculate<div>a) The hot end temperature,</div><div>b)The temperature gradiance at both ends,</div><div>c) The temperature at a section of the rod 0.15 away from the cold end.</div><div><br></div><div>ANS:</div><div>In book the thicker end is taken as x=0; But in this simultion the thinner end is taken as x=0, and with the help of farward difference technic the model is simulated. So there is slight variation with the sign. To get the result as in the book, the thinner end is to be taken as x=0.2, and backward difference technic is to be used to simulate the model.</div></body></html>"));
//Problem statements is given in the Documentation view
  final constant Real pi = 2 * Modelica.Math.asin(1.0);
 
  Real dTdx1(unit = "C/m") "Temperature gradient at end 1";
  Real dTdx2(unit = "C/m") "Temperature gradient at end 2";
  Real T2(unit = "C") "Temperature at end 2";
  Real Tx(unit = "C") "Temperature at 0.15 m from cold end";
  Real[2001] T "Temperature at any position";
  Real[2001] X "Position";
  Integer y1 "Temp variable", y2 "Temp variable";
  parameter Real d1(unit = "m") = 0.06 "Diameter at end 1";
  parameter Real d2(unit = "m") = 0.12 "Diameter at end 2";
  parameter Real T1(unit = "m") = 30 "Temperature at end 1";
  parameter Real Q(unit = "W") = 50 "Heat loss rate";
  parameter Real K(unit = "W/m K") = 15 "Thermal conductivity";
  parameter Real dx(unit = "m") = 0.0001 "Step Size";
  parameter Real l(unit = "m") = 0.2 "Length of the rod";
  
  //In book the thicker end is taken as x=0; But in this simultion the thinner end is taken as x=0, and with the help of farward difference technic the model is simulated. So there is slight variation with the sign. To get the result as in the book, the thinner end is to be taken as x=0.2, and backward difference technic is to be used to simulate the model.
equation
  T[1] = T1;
  X[1] = 0;
  for i in 1:2000 loop
    X[i + 1] = X[i] + dx;
    T[i + 1] = Q / (pi * (0.06 - 0.15 * (0.2 - X[i + 1])) * (0.06 - 0.15 * (0.2 - X[i + 1])) * K) * dx + T[i];
  end for;
/*Sub division a */
  y1 = (l / dx) + 1;
  T2 = T[y1];
/*Sub division b */
  pi * (d1 / 2) ^ 2 * K * dTdx1 = Q;
  pi * (d2 / 2) ^ 2 * K * dTdx2 = Q;
/*Sub division c */
  y2 = (0.15 / dx) + 1;
  Tx = T[y2];
  //There may be a chance of slight changes in the ans from book due to the approximation in the book ans
end Ex2_4;
