model Ex2_6
  annotation(
    Documentation(info = "<html><head></head><body>Two ends of a 5 cm diameter and 50 cm long aaluminum rod, with the curved surface perfectly insulated are maintained at 30 C and 300 C, respectively. The temperaure dependent thermal conductivity of the metal is given by: k=202+0.0545 T,(W/m C), where T is in C. Calculate the temperature gradient at each end of the rod, and the temperature midway in the rod at steady state.</body></html>"));
//Problem statements is given in the Documentation view
parameter Real L(unit="m")=0.5 "Length rod";
parameter Real d(unit="m")=0.05"Diameter of rod"; 
parameter Real dx(unit="m")=0.001"step size";
parameter Real T1(unit="C")=30"Temperature of one end";
parameter Real T2(unit="C")=300"Temperature of other end";
Real x(unit="m")"distance of the midway of the rod from one end";
Integer temp1"Temporary variable_1";
Integer temp2"Temporary variable_2";
Integer temp3"Temporary variable_3";
Real[501] T(unit="C")"Temperature of the rod at any point x";
Real T_0(unit="C")"Temperature at x=0";
Real T_m(unit="C")"Temperature at mid point of the rod";
Real T_L(unit="C")"Temperature at x=L";
Real dTdx_0(unit="C/m")"Temperature gradient at x=0";
Real dTdx_L(unit="C/m")"Temperature gradient at x=L";
equation
x=(L/2);
//Forward difference method is used to solve the second order ordinary differential equation
//to solve the second order differential equation (i.e)d(k(T)*dT/dx)/dx , this equation is rearranged as used here
//Boundary conditions
T[1]=T1;  //at x=0 m
T[501]=T2; //at x=L m
for i in 2:500 loop
T[i]=(((0.0545*dx*T[i-1])-((202+(0.0545*T[i-1]))*T[i+1])-((202+(0.0545*T[i-1]))*T[i-1]))/((0.0545*dx)-(2*(202+(0.0545*T[i-1])))));
end for;
//Location of points
temp1=(1);  //location of end 1
temp2=(x/dx)+1;   //Location of mid point of the rod
temp3=(L/dx)+1;  //Location of end 2  
//Temperature at desired location
T_0=(T[temp1]);
T_m=(T[temp2]);
T_L=(T[temp3]);
//Temperature gradient at both ends
dTdx_0=(T[temp1+1]-T[temp1])/dx;
dTdx_L=(T[temp3]-T[temp3-1])/dx;
// Since numerical technic is used the simulated results are slightly different from book ans
// To get very accurate ans, the step size should be very low and the computer will require very long time to complete the simulation. 
//NOTE:The Loop size should be increased accordingly
end Ex2_6;
