model Ex2_7
  annotation(
    Documentation(info = "<html><head></head><body>The steady state temperature distribution in a 0.3 m thick plane wall is&nbsp;<div>T=600+2500x+12000x^2</div><div>Where T is in C and x is in meter measured from one surface of the wall. One-dimensional steady state heat conduction occurs in the wall along the x-direction. The thermal conductivity of the material of the wall is 23.5 W/m C.</div><div>(a) What are the surface temperature and the average and the average temperature of the wall?</div><div>(b) Calculate the maximum temperature in the wall and its location?</div><div>(c) Calculate the heat fluxes at the surface</div><div>(d) Do you thick thats there is heat generation in the wall? If so, what is the average volumetric rate of heat generation? Is the rate of heat generation uniform?&nbsp;</div></body></html>"));
//Problem statements is given in the Documentation view
parameter Real l(unit="m")=0.3"Thickness of the plane wall";
parameter Real k(unit="W/m C")=23.5"Thermal conductivity of wall";
Real T1(unit="C")"Temperature at x=0 m";
Real T2(unit="C")"Temperature at x=0.3 m";
Real Tav(unit="C")"Average temperature of the wall";
Real x_max(unit="m")"Location of maximum temperature";
Real T_max(unit="C")"Maximum temperature";
Real dTdx_0(unit="C")"Temperature gradient at x=0";
Real dTdx_l(unit="C")"Temperature gradient at x=l";
Real Q_0(unit="W/m^2")"Heat flux at x=0";
Real Q_l(unit="W/m^2")"Heat flux at x=l";
Real Q_av(unit="W/m^3")"Average heat generation rate";
equation
//at left end x=0 m
//Subdivision (a)
//After integration
T1=(600+2500*(0)-12000*(0^2));
T2=(600+(2500*l)-(12000*(l^2)));
Tav=((1/l)*(((600*l)+(2500*(l^2)/2)-(12000*(l^3)/3))));
//Subdivision (b)
//Max temperature location can be found by differentiating the Temeparature distribution equation and equate that to zero
(2500-(2*12000*x_max))=0;
T_max=(600+(2500*x_max)-(12000*(x_max^2)));
//Subdivision (c)
dTdx_0=(2500-(2*12000*(0)));
dTdx_l=(2500-(2*12000*l));
Q_0=((-k)*dTdx_0);
Q_l=((-k)*dTdx_l);
//Subdivision (d)
//Yes, there is a heat generation at the wall and the heat generation is uniform. For explanation about the heat generation refer pg.no(30)-Heat transfer : principles and applications by Binaay K Dutta
Q_av=(Q_l-Q_0)/l;
end Ex2_7;
