model Ex2_8
  annotation(
    Documentation(info = "<html><head></head><body>A rectangular block of material A (Ka=24 W/m C), 0.1 m thick, is sandwiched between two walls of matals B (Kb=230 W/m C) and &nbsp;C (Kc=200 W/m C) of thickness 0.12 m and 0.15 m, respectively. The outer surface temperature of wall B is 100 C and that of wall C is 150 C. Heat generation occurs in A at a uniform volumetric rate of &nbsp;2.5*10^5 W/ m^3. Develop equations for steady state temperature distributions in the three layers and the maximum temperature in the assembly. Also,calculte the percentage of total heat conducted out through the wall B. Assume one dimentional heat flow.</body></html>"));
//Problem statements is given in the Documentation view
parameter Real Kb(unit="W/m C")=230"Thermal conductivity of wall B";
parameter Real Ka(unit="W/m C")=24"Thermal conductivity of wall A";
parameter Real Kc(unit="W/m C")=200"Thermal conductivity of wall B";
parameter Real Qv(unit="W/m^3")=2.5*10^5"Volumetric heat generation at wall A";
parameter Real dx(unit="m")=0.001"Step size";
parameter Real TSb(unit="C")=100"Surface temperature of wall B";
parameter Real TSc(unit="C")=150"Surface temperature of wall C";
Real[121] Tb(unit="C")"Temperature of wall B at any x";
Real[101] Ta(unit="C")"Temperature of wall A at any x";
Real[151] Tc(unit="C")"Temperature of wall C at any x";
Real Qb(unit="W/m^2")"Rate of heat out from wall B";
Real Qc(unit="W/m^2")"Rate of heat out from wall C";
Real P_Qb(unit="%")"Percentage of heat conducted out from wall B";
equation
//Since, deloveloping equation in modelcia is not posible, the temperature at each point with step size dx is found out
// Temperature distribution is found out by Central difference method
//Temperature distribution at wall B
//Boundary condition
Tb[1]=TSb;
Tb[121]=Ta[1];
for i in 2:120 loop
Tb[i]=((Tb[i-1]+Tb[i+1])/2);
end for;
//Temperature distribution at wall A
//Boundary conditions
(Kb*((Tb[121]-Tb[120])/dx))=(Ka*((Ta[2]-Ta[1])/dx));
Ta[101]=Tc[1];
for i in 2:100 loop
Ta[i]=((((Qv/Ka)*(dx^2))+(Ta[i+1])+(Ta[i-1]))/2);
end for;
//Temperature distribution at wall C
//Boundary condition
(Ka*((Ta[101]-Ta[100])/dx))=(Kc*((Tc[2]-Tc[1])/dx));
Tc[151]=TSc;
for i in 2:150 loop
Tc[i]=((Tc[i-1]+Tc[i+1])/2);
end for;
//Perentage of heat out from wall B
//At steady state rate of the rate of heat conduction and rate of heat transfer out are equal
Qb=(Kb*((Tb[2]-Tb[1])/dx)); 
Qc=(Kc*((Tc[150]-Tc[151])/dx));
P_Qb=(((Qb)/(Qb+Qc))*100);
//From the graph the Maximum temperature is 152.643 at x=0.209 m
end Ex2_8;
