model Ex2_9
  annotation(
    Documentation(info = "<html><head></head><body>A two-layer composite cylinder of inner diameter 15 cm and outer diameter 30 cm has moderate volumetric rates of heat generation 100 KW/m^3 and 40 KW/m^3 in the inner and the outer layers, respectively. The thickness of the two layer is equal. The temperature at the inside surface(ri=0.075 m) of the assumbly is 100 C, and that at the outside surface (ro=0.15 m) is 200 C. Thermal conductivities of the outer layer. Determine<div>(a) The temperature distributions in the individual layers</div><div>(b) The maximum temperature in the cylinder and the radial position at which it occurs.</div></body></html>"));
//Problem statements is given in the Documentation view
parameter Real ri(unit="m")=0.075"Inner diameter";
parameter Real ro(unit="m")=0.15"Outer diameter";
parameter Real dr(unit="m")=0.0001"step size";
parameter Real k1(unit="W/m C")=30"Thermal conductivity of layer 1";
parameter Real k2(unit="W/m C")=10"Thermal conductivity of layer 2";
parameter Real TS1(unit="C")=100"Surface temperature of layer 1";
parameter Real TS2(unit="C")=200"Surface temperature of layer 2";
parameter Real Qv1(unit="W/m^3")=10^5"Volumetric heat generation rate at layer 1";
parameter Real Qv2(unit="W/m^3")=40*10^3"Volumetric heat generation rate at layer 1";
Real r_1(unit="m")"interfacial radius";
Real[376] T1(unit="C")"Temperature of layer 2 at any point";
Real[376] T2(unit="C")"Temperature of layer 2 at any point";
Real[375] r1(unit="m")"Radius of layer 1 at any point";
Real[375] r2(unit="m")"Radius of layer 2 at any point";
equation
//Subdivision (a)
r_1=((ri+ro)/2); //thickness if of layer1 and layer 2 are equal
//Since the derivation of equation cannot be done in modelica, the temperature at each point is calculate using central difference method
//Temperature of layer 1
//Central difference method is used to find out the temperature profile
//Boundary condition
r1[1]=ri;
T1[1]=TS1;
T1[376]=T2[1];
for i in 2:375 loop
r1[i]=r1[i-1]+dr;
T1[i]=(((dr*(T1[i-1]))-((r1[i]/k1)*Qv1*(dr^2))-(r1[i]*T1[i-1])-(r1[i]*T1[i+1]))/((dr)-(2*r1[i])));
end for;
//Temperature of layer 2
// Boundary condition
r2[1]=r_1;
T2[376]=TS2;
//step size is significanly small to consider the radius at previos point is approximately equal to the previous point
(k1*((T1[376]-T1[375])/dr))=(k2*((T2[2]-T2[1])/dr));
for i in 2:375 loop
r2[i]=r2[i-1]+dr;
T2[i]=(((dr*(T2[i-1]))-((r2[i]/k2)*Qv2*(dr^2))-(r2[i]*T2[i-1])-(r2[i]*T2[i+1]))/((dr)-(2*r2[i])));
end for;
//Subdivision (b)
//From graph Location of max temperature is r=ro and the max temperature is 200
end Ex2_9;
