model Ex3_1
  annotation(
    Documentation(info = "<html><head></head><body>An ice-ball of initial diameter 0.06 m is suspendede in a room at 30 C. The ice melts by absorbing heat from the ambient, the surface heat transfer coefficent being 11.4 W/m^2 C. The air in the room is essentially dry. If the shape of the ball remains unchanged. Calculate the time required for reduction in its volume by 40 %. The density of ice is 979 Kg/m^3 and its latent heat of fusion is 3.35*10^5 J/kg.</body></html>"));
//Problem statements is given in the Documentation view
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real din(unit="m")=0.06"Initial diameter";
parameter Real h(unit="W/m^2 C")=11.4 "Surface heat transfer coefficient";
parameter Real density(unit="Kg/m^3")=979 "Density of ice";
parameter Real lamda(unit="J/kg")=(3.35*(10^5))"Latent heat of fusion";
parameter Real To(unit="C")= 30"Ambient Temperature";
parameter Real Tb(unit="C")=0"Temperature of ice ball";
Real rin(unit="m")"Inital radius";
Real r40(unit="m")"Radius of ice ball when 40 % is being melt";
Real t40 (unit="hour")"Time to reach 40% melting";
equation
rin=din/2;
((4/3)*pi*(r40^3))=0.6*((4/3)*pi*(rin^3));
//After integration
r40=0.03-((h*(To-Tb))/(density*lamda))*(t40*3600);
//Due to the approximation in book there is a slight change in answer
end Ex3_1;
