model Ex3_2
  annotation(
    Documentation(info = "<html><head></head><body>A 1 KW electric room heater has a coil of nichrom wire of diameter 0.574 mm and electrical resistance 4.167 ohm/m. If the temperature of the room remains constant at 21 C and the average heat transfer coefficient at the surface of the wire is 100 W/m^2 C, calculate the time required for the heating coil, after it is switched on, to reach 63% of its steady state temperature rise. Assume that the wire itself offers negligible heat transfer resistance. The density of the material of the wire is 8920 Kg/m^3, and its specific heat is 384 J/kg C.</body></html>"));
 //Problem statements is given in the Documentation view
 final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real Q(unit="W")=1000"Electrical heating capacity";
parameter Real V(unit="Volt")=220"Applied voltage";
parameter Real R_1(unit="ohm/m")=4.167"Electrical resistance of 1m wire";
parameter Real d(unit="m")=0.574*10^(-3)"Diameter of wire";
parameter Real Tr(unit="C")=21"Room Temperature";
parameter Real h(unit="W/m^2 C")=100"Heat transfer coefficient";
parameter Real density(unit="Kg/m^3")=8920"Density of wire";
parameter Real Cp(unit="J/Kg C")=384"Specific heat of wire";
parameter Real dT(unit="C")=1"Step size";
Real R(unit="ohm")"Electrical resistance of wire";
Real L(unit="m")"Length of the wire";
Real A(unit="m^2")"Heat transfer area";
Real Tf(unit="C")"Steady state temperature";
Real Tfr(unit="C")"Steady state temperature rise";
Real T_63(unit="C")"Temperature of wire at 63% temperature rise";
Real[302] T(unit="C")"Temperature of wire at any time t";
Real[302] t(unit="S")"Time to reach temperature t";
Real t_63(unit="s")"Time to reach 63 % of SS temperature rise";
equation
R=((V^2)/Q); 
L=(R/R_1);
A=(pi*d*L);
Q=h*A*(Tf-Tr);
Tfr=(Tf-Tr);
T_63=(Tr+0.63*Tfr);
//Time required to reach 63% steady state temperature rise
//Initial condition
t[1]=0;
T[1]=Tr;
for i in 1:301 loop
T[i+1]=T[i]+dT;
t[i+1]=(((1/((Q/(density*((pi/4)*d^2)*L*Cp))-((h*A/((density*(pi/4)*(d^2)*L)*Cp))*(T[i+1]-Tr))))*dT)+t[i]);
end for;
t_63=t[301];
end Ex3_2;
