model Ex3_3
  annotation(
    Documentation(info = "<html><head></head><body>The steady state temperature distribution in a 0.2 m thick wall is known to be T=250-2750*x^2, where x is the position in the wall in metre, and T is in C. The thermal conductivity of the material of the wall is 1.163 W/m C. The wall loses heat to an ambient at 30 C.<div>(a) Calculate the heat transfer coeffient at the surface of the wall at x=0.2 m.</div><div>(b) What can be said about the same at the other surface of the wall?</div><div>(c) What i sthe average volumetric rate of heat generation in the wall?</div></body></html>"));
//Problem statements is given in the Documentation view
parameter Real xfinal(unit="m")=0.2 "Thickness of the wall";
parameter Real k(unit="W/m C")=1.163 "Thermal conductivity of the wall";
parameter Real To(unit="C")=30 "Ambient temperature";
parameter Real xinitial(unit="m")=0"Initial thickness of the wall";
Real Tfinal(unit="C")"Interphase wall temperature";
Real dTdxfinal(unit="C/m")"Temperature gradient at interphase";
Real h(unit="W/m^2 C")"Heat trasnfer coefficient";
Real dTdxinitial(unit="C/m")"Temperature gradient at x=0";
Real q(unit="W/m^3")"Average volumetric heat generation";
equation
//subdivision a
Tfinal=250-(2750*(xfinal^2));
dTdxfinal=-2750*2*xfinal;
-k*dTdxfinal=h*(Tfinal-To);
//Subdivision b
//Wall is insulated at the other side.
dTdxinitial=-2750*2*xinitial;
//Subdivision c
q=h*(Tfinal-To)/xfinal;
end Ex3_3;
