model Ex3_6
//Problem statements is given in the Documentation view
final constant Real pi=2*Modelica.Math.asin(1.0);
  annotation(
    Documentation(info = "<html><head></head><body>An insulation flat-heated cylindrical tank (oi.d=1.5 m, height = 2.5 m, wall thickness=0.006 m) is being used as a 'surge drum' in a hot liquid line. The liquid being drawn from the tank is at 80 C. The tank has a 4 cm thick insulation on it except on the bottom surface because it rests on a concrete foundation. The ambient temperature is 25 C. The heat transfer coefficients at the oipen surface are 5.5 W/m^2 C for the flat top and 4 W/m^2 C for the curved surfece.Heat loss from the bottom of the tank can be neglected. The thermal conductivity of the insulation materials is 0.05 W/m C. If the average flow rate os liquid is 700 kg/h and its specific heat is 2000 J/kg C. What should be the temperature of the liquid entering the tank? Assume that (i) Steady state operating conditions exist, (ii)the liquid in the tank is well mixed and (iii) The heat transfer resistance of the 'Liquid film' and tank wall are negligible. Also, Calculate the insulation skin temoerature at the flat top surface and at the cylindrical surface.</body></html>"));
parameter Real di(unit="m")=1.5 "inner diameter of the tank";
parameter Real h(unit="m")=2.5"Height of the tank";
parameter Real ki(unit="W/m C")=0.05 "Themal conductivity of insulation";
parameter Real hc(unit="W/m^2 C")=4 "Heat transfer coefficient at outer cylinder surface";
parameter Real ht(unit="W/m^2 C")=5.5 "Heat transfer coefficient at top flat surface";
parameter Real tw(unit="m")=0.006"thickness of wall";
parameter Real ti(unit="m")=0.04"Thickness of insulation";
parameter Real m(unit="kg/s")=(700/3600)"Liquid flow rate";
parameter Real cp(unit="J/kg C")=2000"Specific heat capacity";
parameter Real Tout(unit="C")=80"Outlet temperature of liquid";
parameter Real Ti(unit="C")=80"Temperature of mixture";
parameter Real To(unit="C")=25"Ambient air temperature";
Real ri(unit="m")"Inner radius of the insulation";
Real ro(unit="m")"outer raius of the insulation";
Real l(unit="m")"Height of the insulation";
Real Rwall(unit="C/W")"Resistance by wall";
Real Rtop(unit="C/W")"Resistance by flat insulated top";
Real DF(unit="C")"Driving force";
Real Q(unit="W")"Heat transfer rate";
Real Tin(unit="C")"Inlet temperature of liquid";
Real Tt(unit="C")"Insulation skin temperature at flat top";
Real Tc(unit="C")"Insulation skin temperature at cylinder";
equation 
//Heat transfer resistance of the cyndrical wall
Rwall=(((log(ro/ri))/(2*pi*l*ki))+(1/(2*pi*ro*l*hc)));
ri=(di/2)+tw;
ro=ri+ti;
l=h+tw+ti;
//Heat transfer resistance of flat insulated top
Rtop=((1/(pi*(ro^2)))*(((ro-ri)/ki)+(1/ht)));
//Driving force for heat transfer
DF=(Ti-To);
//Heat transfer rate
Q=(DF/Rwall)+(DF/Rtop);
//Inlet temperture of liquid
m*cp*(Tin-Tout)=Q;
//Skin temperature
pi*(ro^2)*ht*(Tt-To)=(DF/Rtop);
2*pi*ro*l*hc*(Tc-To)=(DF/Rwall);
//Due to the approximation in book, There is a slight difference in the output and the book answer
end Ex3_6;
