model Ex3_8
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A 10 gauge electrical copper wire has a 1.3 mm thick rubber insulation on it. The life of the insulation depends, among other factors, on the temperature of the wire. It is desired to calculate the maximum allowable current in the wire so that the tempersture of the insulation does not exceed 90 C. The ambient temperature is 30 C, and the outer air-film coefficient is 15 W/m^2 C; Electrical resistance of the copper wire (0.422 ohm/100m).<div>Determine</div><div>(a) The maximum allowable current</div><div>(b) The corresponding temperatures at the centre of the wire and at the outer surface of the insulation.</div></body></html>"));
 final constant Real pi=2*Modelica.Math.asin(1.0);
//Data are given in the book
parameter Real ti(unit="m")=0.0013"Thickness of insulation";
parameter Real Tmax(unit="C")=90"Maximum allowable temperature";
parameter Real Ta(unit="C")=30"Ambient temperature";
parameter Real ho(unit="W/m^2 C")=15"Outer film HTC";
parameter Real Km(unit="W/m C")=380"Thermal conductivity of copper";
parameter Real Ki(unit="W/m C")=0.14"Thermal conductivity of insulation";
parameter Real ri(unit="m")=1.3*10^(-3)"inner radius of insulation";
parameter Real dr(unit="m")=0.01*(10^(-3))"Step size";
parameter Real R_1(unit="ohm/m")=0.422*10^(-2)"Electrical resistance of wire";
Real Imax(unit="A")"Maximum allowable current"; 
Real Qv(unit="W/m^3")"Rate of heat generation by current";
Real ro(unit="m")"Outer radius of insulation";
Real TSc(unit="C")"skin temperature of insulation";
Real[131] rc(unit="C")"radius of insulation at any point";
Real[131] rm(unit="C")"radius of copper at any point";
Real[131] Tc(unit="C")"Temperature of insulation at any point";
Real[131] Tm(unit="C")"Temperature of copper at any point";
Real Tm_0(unit="C")"Center wire temperature";
Real Tc_ro(unit="C")"Skin temperature of insulation";
equation
ro=(ri+ti);
//Temperature profile is obtained by central difference method
//Temperature of insulation
//Boundary condition
rc[1]=ri;
rc[2]=rc[1]+dr;
(Ki*((Tc[130]-Tc[131])/dr))=(ho*(TSc-Ta));
Tc[131]=TSc;
Tc[1]=Tm[131];
for i in 2:130 loop
Tc[i]=(((dr*Tc[i-1])-(rc[i]*Tc[i-1])-(rc[i]*Tc[i+1]))/(dr-(2*rc[i])));
rc[i+1]=rc[i]+dr;
end for;
//Temperature of copper wire
//Initial condition
rm[1]=0;
(Km*((Tm[131]-Tm[130])/dr))=(Ki*((Tc[2]-Tc[1])/dr));
for i in 1:130 loop
Tm[i+1]=((((-1)*((rm[i]*Qv)/(2*Km)))*dr)+Tm[i]);
rm[i+1]=rm[i]+dr;
end for;
//Maximum allowable temperature
Tmax=(Ta+((((ri^2)*Qv)/(2*Ki))*((log(ro/ri))+(Ki/(ho*ro))))); 
//Subdivision (a)
//Maximum allowable current
Imax=((pi*(ri^2)*Qv)/(R_1))^0.5;
//Subdivision (b)
Tm_0=Tm[1];
Tc_ro=(TSc);
//In book, they used dirrect integration, and here second order differtial equation is solved by numerical method, so there is a slight variation in the simulated temperature data with book ans
end Ex3_8;
