model Ex4_12
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Aniline is a tonnage organic chemical used as a raw material for dye intermediates, rubber chemicals and for isocyanates (isocyanates are the starting materials for polyurethanes, a very important commercial polymer). The modern methord of manufacture of aniline is vapour phase catalytic reduction of nitrobenzene by hydrogen.<div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>The reaction gas mixture leaving the catalytic reactor in an aniline plant is condensed in a shell and tube heat exchanger. Condensation occurs in the shell side while cooling water flows at a rate of 0.057 m^3 per minute per tube. Water enters at 32 C. The tube wall temperature may be assumed to remain constant at 80 C. Calculate the rise in temperature of water as it flows through the tubes. the heat transfer coefficient may be estimated from the Dittus-Boeiter equation as well as from the heat transfer analogies described above, taking the physical properties of water at the mean fluid temperature.</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real di(unit="m")=0.0212"Inner diameter of tube";
parameter Real do(unit="m")=0.025"Outer diameter of tube";
parameter Real F(unit="m^3/min")=0.057"Volumetric flow rate of water";
parameter Real density(unit="Kg/m^3")=995"Density of water";
parameter Real vis(unit="Kg/m S")=7.65*10^(-4)"Viscosity of water";
parameter Real K(unit="W/m C")=0.623"Thermal conductivity of water";
parameter Real Cp(unit="KJ/Kg C")=4.17"Specific heat of water";
parameter Real Ti(unit="C")=32"Inlet temperature of water";
parameter Real Tw(unit="C")=80"Wall temperature";
parameter Real L(unit="m")=3"Length of the heat exchanger";
parameter Real density1(unit="kg/m^3")=991"Density of water for recalculation";
parameter Real vis1(unit="Kg/m s")=6.2*10^(-4)"Viscosity of water for recalculation";
parameter Real K1(unit="W/m C")=0.623"Thermal conductivity of water for recalculation";
parameter Real Cp1(unit="KJ/kg c")=4.17"Specific heat of water for recalculation";
Real m(unit="Kg/s")"mass flow rate";
Real V(unit="m/s")"Velocity of water";
Real Re"Reynolds Number";
Real Pr"Prantl number";
Real Nu"Nusselt Number";
Real f"Fannings Friction factor";
Real h"Heat transfer coefficient";
Real Q(unit="W")"Heat transfer rate";
Real LMTD(unit="C")"Log mean temperature difference";
Real To(unit="C")"Outlet temperature of water";
Real Re1"Recalculated reynolds Number";
Real Pr1"Recalculated prandtl number";
Real f1"Recalculated fanning's friction factor";
Real Nu1"Recalculated Nusselt Number";
Real h1(unit="W/m^2 C")"Recalculated HTC";
Real LMTD1(unit="C")"Recalculated Log mean temperature difference";
Real To1(unit="C")"Recalculated outlet temperature of water";
Real Q1(unit="W")"Recalculated Heat transfer rate";
equation
V=((F/60)/((pi/4)*(di^2)));
Re=((di*V*density)/(vis));
Pr=((Cp*1000*vis)/(K));
//Colburn analogy is used. For explanation refer pg.no(141)-Heat transfer principles and application by Binay K Dutta
Nu=((Re)*(Pr^(1/3))*(f/2));
//where
f=(0.0014+(0.125*(Re^(-0.32))));
h=(Nu*K/di);
m=(F/60)*density;
LMTD=((To-Ti)/(log((Tw-Ti)/(Tw-To))));
Q=(h*(pi*di*L)*LMTD);
Q=(m*(Cp*1000)*(To-Ti));
//Recalculation, by using property of water at mean temperature of water
Re1=(di*V*density1/vis1);
Pr1=((Cp1*1000*vis1)/(K1));
Nu1=((Re1)*(Pr1^(1/3))*(f1/2));
f1=(0.0014+(0.125*(Re1^(-0.32))));
h1=(Nu1*K1/di);
LMTD1=((To1-Ti)/(log((Tw-Ti)/(Tw-To1))));
Q1=(h1*(pi*di*L)*LMTD1);
Q1=(m*(Cp1*1000)*(To1-Ti));
end Ex4_12;
