model Ex4_2
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Air flows over a flat surfece, 2 m in length oriented in the direction of flow and of surfficient breadth, maintained at 150 C. The pressure is 1 atm and bulk air temperature is 30 C. If the air velocity is 12 m/s, determine&nbsp;<div>(a) the local heat transfer coefficient as a function of longitudinal position,</div><div>(b) the average heat transfer coefficient</div><div>(c) the rate of heat loss from the surface&nbsp;</div></body></html>"));
parameter Real T(unit="C")=150"Surface Temperature";
parameter Real Ta(unit="C")=30"Bulk air temperature";
parameter Real density(unit="kg/m^2")=0.962          "Density of air";
parameter Real viscosity(unit="kg/m S")=2.131*(10^(-5))"Viscosity of air";
parameter Real k(unit="W/m C")=0.031"Thermal conductivity of air";
parameter Real Cp(unit="J/Kg C")=1010"Specific heat capacity";
parameter Real L(unit="m")=2 "Length of the plate";
parameter Real V(unit="m/s")=12"m/s";
Real Tf(unit="C")             "Film temperature";
Real Re(unit="Dimensionless")"Reynolds NO";
Real Pr(unit="Dimensionless")"Prandtl NO";
Real L1(unit="m")"Length at which flow becomes turbulent";
Real hav(unit="W/m^2 C")"Average Heat transfer coefficient";
Real Q(unit="W")"Heat transfer Rate";
equation
//Subdivision a cannot be simulated. It is a analytical derivation
//ans is h=31.4*x^(1/5)

//subdivision (b)
Tf=(T+Ta)/2;
Pr=((Cp*viscosity)/k);
Re=((L*V*density)/viscosity);
//when reynolds number exceeds 5*10^5 the flow becomes tubulent from transiant
//TO find out the length at which the flow becomes tubulent
(5*(10^5))=((L1*V*density)/viscosity);
//Average heat transfer coeeficient by finding out the H.T.C for the turbulent and laminar region separately
//For knowing more about the used correlation ref. Pg.No: 112 (Heat Transfer: Principles and application by Dutta,Binay.K) 
hav=(1/L)*((0.332*(((V*density)/viscosity)^0.5)*(Pr^(1/3))*(k)*2*(L1^0.5))+((0.0296)*(Pr^(1/3))*k*(((V*density)/viscosity)^(4/5))*(5/4)*((L^(4/5))-(L1^(4/5)))));
// Subdivision (c)
//Heat transfer rate for 1 m breadth
Q=hav*L*(T-Ta);
end Ex4_2;
