model Ex4_5
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>A Stream of solid particles at 800 C is to be colled to 550 C in a fluidized bed. Air is the fluidizing medium and it has a mean temperature of 500 C in the bed. The pressure in the bed is maintained at 1.2 atm absolute and the superficial air velosity is 0.5 m/s. Calculate the average time of contact between the solid and the gas required for the desired cooling of the solid. Assume that the gas film heat transfer resistance control.</body></html>"));
  //Data are given in the question statement
  //data of partical
  parameter Real dp(unit = "m") = 0.00065 "Diameter of the partical";
  parameter Real Cps(unit = "Kcal/kg C") = 0.198 "Specific heat of partical";
  parameter Real ros(unit = "kg/m^3") = 2550 "Density of partical";
  //Data of air
  parameter Real ro(unit = "Kg/m^3") = 0.545 "Density of air";
  parameter Real Cp(unit = "KCal/Kg C") = 0.263 "Specif heat of air";
  parameter Real viscosity(unit = "Kg/m s") = 3.6 * 10 ^ (-5) "Viscosity of air";
  parameter Real k(unit = "KCal/s m C") = (0.050/3600) "Thermal conductivit of air";
  parameter Real V(unit="m/s")=0.5"Velosity of air";
  parameter Real Tg(unit="C")=500"temperature of air";
  parameter Real Tsi(unit="C")=800"Inlet temperature of solid";
  parameter Real Tso(unit="C")=550"Outlet temperature of solid";
  parameter Real dT(unit="C")=1"Step size";
  Real Re"Reynolds Number";
  Real Pr"Prandtl Number";
  Real h(unit="Kcal/h m^2 C")"Heat transfer coefficient";
  Real[251] t(unit="h")"Contact time";
  Real t550(unit="s")"Required contact time to reach 550 C";
  Real[251] Ts(unit="C")"Temperature of parical at any time";
  Integer temp"Temporary variable";
  equation
  Re=(dp*V*ro/viscosity);
  Pr=(Cp*viscosity/k);
  ((h/3600)*dp/k)=(2+(0.6*(((dp*V*ro)/viscosity)^(1/2))*(((Cp*viscosity)/k)^(1/3))));
  //To find out contact time backward difference technic is used
  //Initial contition
  Ts[1]=800;
  t[1]=0;
  for i in 1:250 loop
  t[i+1]=((dp*ros*Cps/(6*h))*(1/(Ts[i]-Tg)))*dT+(t[i]);
  Ts[i+1]=Ts[i]-dT;
  end for;
  temp=((Tsi-Tso)/dT)+1;
  //Required contact time
  t550=(t[temp])*3600;
end Ex4_5;
