model Ex5_1
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A furnace with a steel door, having an inner lining of an insulating material, is at a temperature of 65 C. The door, 1.5 m high and 1 m wide, loses heat to an ambient at 25 C. Calculate the rate of heat loss from the door at steady state.</body></html>"));
parameter Real T1(unit="C")=65"Furnace temperature";
parameter Real T2(unit="C")=25"Ambient temperature";
parameter Real Pr=0.695"Prandtl Number";
parameter Real k(unit="W/m C")=0.028"Thermal conductivity of air";
parameter Real L(unit="m")=1.5"Door height";
parameter Real g(unit="m/s^2")=9.8"Gravitational acceleration";
parameter Real ki_vis(unit="m^2/s")=1.85*10^(-5)"Kinamatic viscosity";
parameter Real A(unit="m^2")=1.5"Area of heat transfer";
Real Tf(unit="K")"Film temperature";
Real Gr"Grashof Number";
Real Ra"Rayleigh Number";
Real beta(unit="K^-1")"Thermal Expansion coefficient";
Real Nu"Nusselt Number";
Real h(unit="W/m^2 C")"Heat transfer coefficient";
Real Q(unit="W")"Heat transfer rate";
equation
Tf=((T1+T2)/2)+273;
Gr=((g*beta*(T1-T2)*(L^3))/(ki_vis^2));
beta=(1/Tf);
Ra=(Gr*Pr);
Nu=(h*L/k);
Nu=((0.825+((0.387*(Ra^(1/6)))/((1+((0.492/Pr)^(9/16)))^(8/27))))^2);
Q=h*A*(T1-T2);
end Ex5_1;
