model Ex5_5
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>The sulphur dioxide converter in a sulphuric acid plant is a tall cylindrical vessel housing four catalyst chamber for stage-wise conversion to sulphur trioxide with inter stage cooling of gas mixture. A 100 tpd (tonnes per day) plant has a converter 10.5 m in height and 4 m in diamter. It is insulated with a layer of mineral wood(ki=0.0602 Kcal/h m C). Although the temperature in the reactor varies from one stage to another, an average reactor wall temperature of 460 C may be assumed. If heat loss from the insulated reactor occurs only by free convection, What thickness of insulation should be used so that the insulation skin temeprature does not exceed 65 C? the ambient temeprature may be taken as 30 c.</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
// Data are given in the book
parameter Real Ta(unit="C")=30"Ambient temperature";
parameter Real Ts(unit="C")=65"Skin temperature";
parameter Real ki_vis(unit="m^2/S")=1.84*10^(-5)"Kinamatic viscosity";
parameter Real L(unit="m")=10.5"Height";
parameter Real g(unit="m/S^2")=9.8"Gravitational acceleration";
parameter Real d(unit="m")=4"Vessel diameter";
parameter Real Pr=0.705"Prsandtl Number";
parameter Real k(unit="Kcal/h m C")=0.0241"Thermal conductivity of air";
parameter Real ki(unit="Kcal/h m C")=0.0602"Thermal conductivity of insulation";
parameter Real Tr(unit="C")=460"Average temperature in the reactor";
Real Tf(unit="K")"Skin temperature";
Real beta(unit="K^-1")"Thermal expansion coefficient";
Real Gr"Grashof Number";
Real Ra"Rayleigh Number";
Real h(unit="Kcal/h m^2 C")"Heat transfer coefficient";
Real A(unit="m^2")"Heat transfer area of insulation";
Real Ac(unit="m^2")"Convective heat transfer area";
Real da(unit="m")"Average insulation diameter";
Real Qi(unit="Kcal/hr")"Heat transfer rate through insulation";
Real Qc(unit="Kcal/hr")"Convective heat transfer rate";
Real w(unit="m")"Thickness of the insulation";
equation
Tf=((Ta+Ts)/2)+273;
beta=(1/Tf);
Gr=((g*beta*(Ts-Ta)*(L^3))/(ki_vis^2));
//The following correlation is used to find out H.T.C. For the explanation refer Pg.No:159 - Heat transfer principles and applications by Binay K Dutta
(h*L/k)=(0.825+((0.387*(Ra^(1/6)))/((1+((0.496/Pr)^(9/16)))^(8/27))))^2;
Ra=Gr*Pr;
//The thickness of the insualtion will be very small compared to the diameter of the vessel, so that it is valid to use arithmatic mean average diameter
da=(d+(d+2*w))/2;
A=pi*da*L;
(Qi*w)=((ki*A*(Tr-Ts)));
Ac=pi*(d+(2*w))*L;
Qc=h*Ac*(Ts-Ta);
//In steady state Heat transfer rate by convection is equal to the heat transfer rate by conduction through the insulation 
Qi=Qc;
end Ex5_5;
