model Ex5_7
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A horizontal section of an uninsalted pipe, 60 mm o_d, caarrying warm water runs below an exhaust fan in a factory shed. The fan creates a suction that causes a mild upward cross flow velocity of 0.3 m/s on the pipe. If the pipe wall temperature is 60 C. Calculate the rate of heat loss by the &nbsp; combined free and forced convection per meter length of the pipe. The ambient air temperature is 30 C.</body></html>"));
 final constant Real pi=2*Modelica.Math.asin(1.0);
//data are given in the problem statement
parameter Real Tw(unit="C")=60"Pipe wall temperature";
parameter Real Ta(unit="C")=30"Ambient temperature";
parameter Real density(unit="Kg/m^3")=1.105"Density of air";
parameter Real Cp(unit="Kcal/kg C")=0.24"Specific heat capacity of air";
parameter Real viscosity(unit="kg/m s")=1.95*10^(-5)"Viscosity";
parameter Real k(unit="Kcal/h m C")=0.0241"Thermal conductivity of air";
parameter Real Pr=0.7 "Prandtl Number";
parameter Real V(unit="m/s")=0.3"air velocity";
parameter Real d(unit="m")=0.06"Diameter of the pipe";
parameter Real g(unit="m/s^2")=9.8"Gravitational acceleration";
parameter Real L(unit="m")=1"length of pipe";
Real ki_vis(unit="m^2/s")"Kinamatic viscosity"; 
Real beta(unit="K^-1")"Thermal expansion coefficient";
Real Tm(unit="C")"mean temperature of air";
Real Gr"Grashof Number";
Real Ra"Rayleigh Number";
Real Nu_free"Free Nusselt Number";
Real Nu_forced"Forced Nusselt Number";
Real Nu"Mixed Nusselt Number";
Real h(unit="Kcal/h m^2 C")"Heat transfer coefficient";
Real Q(unit="Kcal/hr")"Heat loss rate";
Real A(unit="m^2")"Area of heat transfer";
Real Re"Reynolds Number";
equation 
ki_vis=(viscosity/density);
beta=(1/Tm);
Tm=((Tw+Ta)/2)+273;
Gr=(g*beta*(Tw-Ta)*(d^3)/(ki_vis^2));
Ra=Gr*Pr;
Nu_free=((0.6+((0.387*(Ra^(1/6)))/((1+((0.559/Pr)^(9/16)))^(8/27))))^2);
Nu_forced=(0.3+(((0.62*(Re^0.5)*(Pr^(1/3)))/((1+((0.4/Pr)^(2/3)))^(1/4)))*((1+((Re/(2.82*10^5))^(5/8)))^(4/5))));
Re=(d*V/ki_vis);
(Nu^3)=(Nu_free^3)+(Nu_forced^3);
Nu=(h*d/k);
A=pi*d*L;
Q=(h*A*(Tw-Ta));
//since there is mistake in the kinamatic viscosity calculation in book, the simulated heat loss rate is slighty different from the book ans
end Ex5_7;
