model Ex7_10
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>An enclosure consists of two black surface formed by cutting off a 0.3 m diameter spherical shell by a plane at a distance 0.1 m from the centre and closing it by a black circular disk. Determine the view factor. fig-refer p.no 235 (Heat transfer principles and application by Binay K dutta)</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real F12=1"View factor 1-2";
parameter Real R(unit="m")=0.15"Radius of sphere";
parameter Real r1(unit="m")=0.1"Distance of the disk from the centre";
Real r2(unit="m")"Radius of disk";
Real A1(unit="m^2")"Area 1";
Real A2(unit="m^2")"Area 2";
Real F21"View factor 2-1";
equation
r2=sqrt((R^2)-(r1^2));
A1=(pi*(r2^2));
A2=((2*pi*(R^2))+((2*pi*R)*(sqrt((R^2)-(r2^2)))));
F21=((A1/A2)*(F12));
end Ex7_10;
