model Ex7_15
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>A black wall of emissivity 0.8 is 6 m wide and 5 m high. It stands at a distance of 3 m from a 15 cm *12 cm opening on a furnace in a boiler room. The centre line of the furnace opening lies 1 m left and 1 m below the centre point of the wall as shown in the fig 7.29. If the wall temperature is 35 C and the furnace temperature is 1400 C, calculate the net rate of radiant heat transfer to the wall. The furnace opening can be considered as a blackbody.<div><br></div><div>NOTE:fig- refer pg.no 248 (\"Heat transfer principles and application\" by Binay K Dutta)</div></body></html>"));
parameter Real L1(unit="m")=2 "Length of AF";
parameter Real L2(unit="m")=1.5 "Length of AH";
parameter Real H(unit="m")=3 "E-dA1";
parameter Real L3(unit="m")=4 "Length of CG";
parameter Real L4(unit="m")=3.5 "Length of CI";
parameter Real H1(unit="m")=3 "E-dA1";
parameter Real L5(unit="m")=2 "Length of BG";
parameter Real L6(unit="m")=3.5"Length of BH";
parameter Real H2(unit="m")=3"E-dA1";
parameter Real L7(unit="m")=4 "Length of DF";
parameter Real L8(unit="m")=1.5"Length of DI";
parameter Real H3(unit="m")=3"E-dA1";
parameter Real A1(unit="m^(2)")=0.018 "Area 1";
parameter Real A2(unit="m^(2)")=30 "Area of the wall";
parameter Real E2(unit="No units")=0.8 "Emissivity";
parameter Real S(unit="W/m^(4)")=5.67*10^(-8) "Stefan Boltzmann constant";
parameter Real T1(unit="K")=1400"Furnace Temperature";
parameter Real T2(unit="K")=35 "Wall temperature";
parameter Real E1(unit="No units")=0.8 "Emissivity";
 Real Eb1(unit="W") "Emissive power 1";
 Real Eb2(unit="W") "Emissive power 2";
 Real FW1(unit="No units") "Fraction of radiation from surface";
 Real Q(unit="W") "Rate of radiation";
 Real F1w(unit="No units") "Fraction from surface 1";
Real F12(unit="No units") "Fraction of radiation from A1";
Real F14(unit="No units") "Fraction of radiation from A3";
Real F13(unit="No units") "Fraction of radiation from A2";
Real F15(unit="No units") "Fraction of radiation from A4";
equation
F12=1/(2*3.14)*((L2/(sqrt(L2^(2)+H^(2))))*atan(L1/(sqrt(L2^(2)+H^(2))))+(L1/(sqrt(L1^(2)+H^(2))))*atan(L2/(sqrt(L1^(2)+H^(2)))));
F14=1/(2*3.14)*((L4/(sqrt(L4^(2)+H1^(2))))*atan(L3/(sqrt(L4^(2)+H1^(2))))+(L3/(sqrt(L3^(2)+H1^(2))))*atan(L4/(sqrt(L3^(2)+H1^(2)))));
F13=1/(2*3.14)*((L6/(sqrt(L6^(2)+H2^(2))))*atan(L5/(sqrt(L6^(2)+H2^(2))))+(L5/(sqrt(L5^(2)+H2^(2))))*atan(L6/(sqrt(L5^(2)+H2^(2)))));
F15=1/(2*3.14)*((L8/(sqrt(L8^(2)+H3^(2))))*atan(L7/(sqrt(L8^(2)+H3^(2))))+(L7/(sqrt(L7^(2)+H3^(2))))*atan(L8/(sqrt(L7^(2)+H3^(2)))));
F1w=F12+F13+F14+F15;
Eb1=S*(T1^(4)+(273)^(4));
Eb2=S*(T2^(4)+(273)^(4));
FW1=(A1*F1w)/(A2);
Q=A1*F1w*E1*S*((T1+273)^(4)*(1-(1-E1)*(FW1))-(T2+273)^(4));
//due to the approximation in the book, there is slight difference in the simulated results with the book ans
end Ex7_15;
