model Ex7_16
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>The base of a rectangular enclosure (3m*2m; height=3m) is maintained at 400 C (fig. 7.30). The top surface is held at 250 C.<div>(a) If the side walls are perfectly insulated and the surfaces are diffuse gray with an emissivity 0.7, calculate the required net rate of heat supply to the base.</div><div>(b)If the skin temperature of the outside of the top wall is 60 C and heat loss from this surface occurs to a big factory shade at 30 C, what is the convective heat transfer coefficient at this surface?</div><div><br></div><div>NOTE: fig- refer pg.no 250 (\"Heat transfer principles and applications\" by Binay K Dutta)</div></body></html>"));
parameter Real A(unit="m^(2)")=6 "Area";
parameter Real S(unit="W/T^(4)")=5.668*10^(-8) "Stefan boltzmann constant";
parameter Real T1(unit="K")=673 "Temperature1";
parameter Real T2(unit="K")=523 "Temperature2";
parameter Real T3(unit="K")=333 "Temperature1";
parameter Real T4(unit="K")=303 "Temperature2";
parameter Real E1(unit="No units")=0.7 "Emissivity";
parameter Real F12(unit="No units")=0.148 "Fraction of radiation emitted from the surface1 to 2";
parameter Real F24(unit="No units")=1 "Fraction of radiation emitted from the surface2 to 4";
Real Q1(unit="W")"Rate of heat input to the base";
Real Q2(unit="W")"Rate of heat loss by radiation from the outside of the top wall";
Real Q(unit="W")"Rate of heat loss";
Real h(unit="W/m^(2).0C") "Convective heat transfer";
equation
//Subdivision (a)
Q1=((A*S*(T1^(4)-T2^(4)))/((((A+A)-(2*F12*A))/(A-(A*(F12)^(2))))+((1/E1)-1)+((A/A)*((1/E1)-1))));
//Here A1=A2 and E1=E2//
//Subdivision (b)
Q2=(A*E1*S*F24*(T3^(4)-T4^(4)));
Q=Q1-Q2;
A*h*(T3-T4)=Q;
//Due to the approximation in the book calculation, there is a difference in the simulated value with the book ans
end Ex7_16;
