model Ex7_9
//Problem statements is given in the Documentation view
annotation(
    Documentation(info = "<html><head></head><body>Consider an enclosure formed by closing one end of a cylinder (diameter=D, Height=H) by a flat surface the other end by a hemispherical dome. Determine the view factors of all the surfaces of the enclosure if the height is twice the diameter.</body></html>"));
parameter Real R1(unit="cm")=0.25 "Radius of flat surface";
parameter Real R2(unit="cm")=0.25 "Radius of cylinder surface";
parameter Real F11(unit="No units")=0 "Fraction of emission from the flat surface";
parameter Real F33(unit="No units")=0.5 "Fraction of emission from thr hemisphere";
Real X(unit="No units") "Factor";
Real F14(unit="No units") "Fraction of emission from the dotted line";
Real F13(unit="No units") "Fraction of emission from the hemisphere";
Real F12(unit="No units") "Fraction of emission from flat surface to cylinder";
Real F31(unit="No units") "Fraction of emission from the hemisphere to flat surface";
Real F32(unit="No units") "Fraction of emission from hemisphere from cylinder";
Real F21(unit="No units") "Fraction of emission from the cylinder to flat surface";
Real F22(unit="No units") "Fraction of emission from the cylinder";
Real F23(unit="No units") "Fraction of emission from the cylinder to hemisphere";
Real[3,3] F"View factor matrix";
equation
X=1+(1+(R2^(2)))/R1^(2);
F14=(1/2)*(X-sqrt(X^(2)-4));
F14=F13;
F11+F12+F13=1;
F31=(3.14*2)/(3.14*4)*(F14);
F31+F32+F33=1;
F21=F12/8;
F23=F32/4;
F21+F22+F23=1;
F={{F11,F12,F13},{F21,F22,F23},{F31,F32,F33}};
//Due to approximation in the book calculation, there is slight difference in the simulated results with the book ans
end Ex7_9;
