model Ex8_1
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>Benzene from &nbsp;the condenser at the top of a distillation column is cooled at a rate of 1000 kg/h from 75 C to 50 C in a countercurrent double pipe heat exchanger. The construction of the heat exchanger is of hairpin type with an effective length of 15 m. The inner tube is of carbon steel, 25 mm od., BWG. The outer pipe is schedule 40, 1-1/2 inch nb (nominal bore). Benzene flows through the annulus. Water flows through the inner tube, entering at 30 C and leaving at 40 C is the coolant.<div>(a) Calculate the heat duty of heat excahnger and the water flow rate.</div><div>(b) Calculate the individual film coefficients and the overall coefficient based on both inside and outside area.</div><div>(c)Do you think that the tube walls have gathered scale and have been fouled? If so estimate the fouling factor?</div></body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0); 
//Data are given in the problem statement
parameter Real id(unit="m")=0.021"Inner diameter of the inner pipe";
parameter Real od(unit="m")=0.0254"Outer diameter of pipe";
parameter Real t(unit="m")=0.0022"Wall thickness";
parameter Real k(unit="W/m C")=74.5"Thermal conductivity of tube wall";
parameter Real ID(unit="m")=0.041"Inner diameter of Outer pipe";
parameter Real OD(unit="m")=0.048"Outer diamter of the outer pipe";
parameter Real Cp_b(unit="KJ/Kg C")=1.88"Specific heat capacity of benzene";
parameter Real vis_b(unit="kg/m S")=3.7*10^(-4)"VIscosity of benzene";
parameter Real ro_b(unit="Kg/m^3")=860"Density of benzene";
parameter Real k_b(unit="W/m K")=0.154"Thermal conductivity of benzene";
parameter Real vis_w(unit="Kg/m S")=8*10^(-4)"Viscosity of water";
parameter Real k_w(unit="W/m C")=0.623"Thermal conductivity of water";
parameter Real m_b(unit="Kg/h")=1000"Mass flow rate of benzene";
parameter Real Tbi(unit="C")=75"Inlet temperature of benzene";
parameter Real Tbo(unit="C")=50"Outlet temperature of benzene";
parameter Real Twi(unit="C")=30"Inlet temperature of water";
parameter Real Two(unit="C")=40"Outlet temperature of water";
parameter Real Cp_w(unit="C")=4.187"Specific heat capacity of water";
parameter Real ro_w(unit="Kg/m^3")=1000"Density of water";
parameter Real La(unit="m")=15"Actual length of the heat exchanger";
Real Ai(unit="m^2")"Tube FLow area";
Real Q(unit="KJ/h")"Heat duty";
Real m_w(unit="KJ/h")"mass flow rate of water";
Real v_w(unit="m/s")"Velocity of water";
Real Re_w"Tube side reynolds number";
Real Pr_w"Prandtl Number of water";
Real Nu"Tube side Nusselt Number";
Real hi(unit="W/m^2 C")"Tube side H.T.C";
Real Ao(unit="m^2")"Outside flow area";
Real dh(unit="m")"Hydraulic diameter";
Real p(unit="m")"wetted perimeter";
Real v_b(unit="m/s")"Velocity of benzene";
Real Re_b"Outside Reynolds Number";
Real Pr_b"Prandtl number of benzene";
Real Nu_b"Nusselt Number for outside";
Real ho(unit="W/m^2 C")"Outside H.T.C";
Real Uo(unit="W/m^2 C")"Outside Overall Heat transfer Coefficient";
Real Ui(unit="W/m^2 C")"Inside Overall Heat transfer coefficient";
Real A_o(unit="m^2")"Outside Convective area";
Real LMTD(unit="C")"Log mean temperature difference";
Real L(unit="m")"Required Heat exchanger length";
Real Ah(unit="m^2")"outside Heat transfer area of hair pin";
Real Rd(unit="m^2 C/W")"Fouling factor";
Real Udo(unit="W/m^2 C")"Actual Outside Heat Transfer Coefficient";
equation
//Subdivision (a)
Q=(m_b*Cp_b*(Tbi-Tbo));
m_w=(Q/(Cp_w*(Two-Twi)));
//Subdivision (b)
//Tube side (water) calculation
Ai=((pi/4)*(id^2));
v_w=(((m_w/3600)/ro_w)/Ai);
Re_w=((id*v_w*ro_w)/vis_w);
Pr_w=(((Cp_w*1000)*vis_w)/k_w);
Nu=(0.023*(Re_w^0.8)*(Pr_w^0.3));
Nu=((hi*id)/k_w);
//Outside (benzene) Calculation
Ao=(((pi/4)*(ID^2))-((pi/4)*(od^2)));
p=(pi*(ID+od));
dh=((4*Ao)/(p));
v_b=(((m_b/3600)/ro_b)/Ao);
Re_b=((dh*v_b*ro_b)/vis_b);
Pr_b=(((Cp_b*1000)*vis_b)/k_b);
Nu_b=(0.023*(Re_b^0.8)*(Pr_b^0.4));
Nu_b=(ho*dh/k_b);
//Outside overall HTC
Uo=(1/((1/ho)+(((od)/((od-id)/(log(od/id))))*((od-id)/(2*k)))+((od/id)*(1/hi))));
//Inside overall HTC
(Ui*id)=(Uo*od);
//LMTD
LMTD=(((Tbi-Two)-(Tbo-Twi))/(log((Tbi-Two)/(Tbo-Twi))));
(Q*1000/3600)=(Uo*A_o*LMTD);
A_o=(pi*od*L);
//Subdivision (C)
Ah=(pi*od*La);
(Q*1000/3600)=(Udo*Ah*LMTD);
Rd=((1/Udo)-(1/Uo));
//Since the solver is working based on the iterative calculation, to get the converged ans the equations are rearranged
//Due to the approximation in the book there is slight variation in the simulated results with the book ans
end Ex8_1;
