model Ex8_3
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A heat transfer oil (specific heat =0.454 Kcal/Kg C) leaving a hydraulic system at a rate of 10000 Kg/h at 85 C has to be cooled to 50 C before it can be circulated back to the system. It is desired to determine wheter an existing 1-2 pss exchanger having an area of 15 m^2 would be siutble. Water is avaliable at 30 C and must not be heated to above 38 C. An overall heat Transfer coefficient (including the dirt factor) of 400 kcal/h m^2 C can be attained in the heat exchanger. Water flows thtough the tubes.<div><span class=\"Apple-tab-span\" style=\"white-space:pre\">	</span>How will th eheat transfer rate and the exit oil temperature be affected if the water flow rate is increased by 20%? The overall heat transfer coefficient Ud is assumed to remain unchanged.</div><div><br></div></body></html>"));
 final constant Real e=Modelica.Math.exp(1.0);
parameter Real W_h(unit="Kg/h")=10000"Hot stream mass flow rate";
parameter Real Cph(unit="Kcal/Kg C")=0.454"Specific heat capacity";
parameter Real Th1(unit="C")=85"Hot stream Intlet temperature";
parameter Real Th2(unit="C")=50"Hot stream Outlet temperature";
parameter Real Cpc(unit="Kcal/Kg C")=1"Cold stream Specific heat capacity";
parameter Real Tc2(unit="C")=30"Cold stream inlet temperature";
parameter Real Tc1(unit="C")=38"Cold stream outlet temperature";
parameter Real Ud(unit="Kcal/h m^2 C")=400"Overall heat transfer coefficient";
parameter Real A_a(unit="m^2")=15"Available area of heat trasnfer";
Real W_c(unit="Kg/h")"COld stream mass flow rate";
Real Cmin(unit="Kcal/h c")"Minimum mcp";
Real Cmax(unit="Kcal/h C")"Maximum mcp";
Real Cr"Ratio of Cmin to Cmax";
Real Effectiveness"Effectiveness";
Real NTU"Number of transfering unit";
Real A_r(unit="m^2")"Heat trasnsfer area required";
Real p_e(unit="%")"Percentage excess area available";
Real m_20(unit="Kg/h")"20% increased water mass flow rate";
Real Cmax_new(unit="Kcal/h C")"Cmax value when water flow increased by 20%";
Real Cr_new"Cr when water flow increased by 20 %";
Real eff_new"Effectiveness when water flow increased by 20%";
Real Th2_new(unit="C")"outlet temperature of oil when water flow rate is increses by 20%";
Real Q1(unit="Kcal/h")"Rate of heat transfer when there is no flow change";
Real Q2(unit="Kcal/h")"Rate of heat transfer when the water flow rate is 20% increased";
Real p_Q(unit="%")"Percentage increase in heat transfer";
equation
//Heat balance
(W_c*Cpc*(Tc1-Tc2))=(W_h*Cph*(Th1-Th2));
Cmin=(W_h*Cph);
Cmax=(W_c*Cpc);
Cr=(Cmin/Cmax);
Effectiveness=((Th1-Th2)/(Th1-Tc2));
//Number of transfering unit
NTU=((-(1+(Cr^2))^(-1/2))*(log(((2/Effectiveness)-(1+Cr)-((1+Cr^2)^(1/2)))/((2/Effectiveness)-(1+Cr)+((1+Cr^2)^(1/2))))));
//Required heat transfer area
A_r=((NTU*Cmin)/(Ud));
//Percentage of excess area available
p_e=(((A_a-A_r)/A_r)*100);
//When the water flow rate is increased by 20%
m_20=(W_c+(W_c*0.2));
Cmax_new=(m_20*Cpc);
Cr_new=(Cmin/Cmax_new);
eff_new=(2*((((1+Cr_new)+(((1+Cr_new^2)^(1/2))*((1+(e^((-1)*((1+Cr_new^2)^(1/2))*(NTU))))/(1-(e^((-1)*((1+Cr_new^2)^(1/2))*(NTU)))))))^(-1))));
eff_new=((Th1-Th2_new)/(Th1-Tc2));
Q1=(W_h*Cph*(Th1-Th2));
Q2=(W_h*Cph*(Th1-Th2_new));
//Percentage increase in heat transfer when water flow rate increased by 20%
p_Q=((Q2-Q1)/(Q1))*100;
//Due to roundup in the book there is slight variation in the simulated result in heat transfer rate and percentage increases in the heat transfer rate
end Ex8_3;
