model Ex9_2
//Problem statements is given in the Documentation view
  annotation(
    Documentation(info = "<html><head></head><body>A single-effect, vertical short-tube evaporator is used to concentrate a suryp from 10% to 40% solid at &nbsp;the rate of 2000 kg of feed per hour. The feed enters at 30 C and a reduced pressure of 0.33 kg/cm^2 is maintained in the vapour space. At this pressure, the liquid boils at 75 C. saturated stream at 115 C is supplied to the steam chest. No sub-cooling of the condensate occurs. Clculate the steam requirement and the tubes (0.0254 m,16 BWG) if the height of the calandria is 1.5m. The following data are given: specific heat of liquor=0.946 Kcal/kg C. Latent heat of steam at 0.33 Kg/cm^2=556.5 Kcal/Kg. Boiling point of the water at this pressure = 343 K. The overall heat &nbsp;transfer coefficient=2150 Kcal/h m^2 C.</body></html>"));
final constant Real pi=2*Modelica.Math.asin(1.0);
parameter Real Wf(unit="Kg/h")=2000"Feed mass flow rate";
parameter Real xf=0.1"Solute mass fraction in feed";
parameter Real xp=0.4"Solute mass fraction in product";
parameter Real Tf(unit="C")=30"Feed temperature";
parameter Real Tr(unit="C")=75"Reference temperature"; //Taken
parameter Real Tp(unit="C")=75"Product temperaure";
parameter Real Cpf(unit="Kcal/kg C")=0.946"Specific heat of feed";
parameter Real Ls(unit="Kcal/kg")=529.5"Latent heat of vaporization of steam";
parameter Real Lv(unit="Kcal/kg")=556.5"Latent heat of vaporization of vapour";
parameter Real BP_L(unit="C")=75"Solution boiling point";
parameter Real BP_w(unit="K")=345"Boiling point of water";
parameter Real Ts(unit="C")=115"Temperature of steam";
parameter Real U(unit="Kcal/h m^2 C")=2150"Inside overall Heat transfer coefficient";
parameter Real id(unit="m")=0.0221"inner diameter of tube";
parameter Real l(unit="m")=1.5"Length of the tube";
Real Ws(unit="Kg/h")"Mass flow rate of solute";
Real Wp(unit="Kg/h")"Product flow rate";
Real Wv(unit="Kg/h")"Vapour flow rate";
Real Hf(unit="Kcal/kg")"Enthalpy of feed";
Real Hp(unit="Kcal/kg")"Enthalpy of product";
Real Hv(unit="Kcal/kg")"Enthalpy of vapour";
Real BPE(unit="C")"Boiling point elivation";
Real S(unit="Kg/h")"Steam flow rate";
Real Q(unit="Kcal/h")"Rate of heat transfer";
Real A(unit="m^2")"Heat transfer area";
Integer N"Number of tubes";
equation
//Mass balance
Ws=(Wf*xf);
Ws=(Wp*xp);
Wv=(Wf-Wp);
//Heat balance
Hf=(Cpf*(Tf-Tr));
Hp=0;//Since the temperature of product and reference temperature are same
Hv=(Hp+Lv);
BPE=((BP_L+273)-BP_w);
((Hf*Wf)+(S*Ls))=((Hp*Wp)+(Hv*Wv));
Q=(S*Ls);
A=((Q)/(U*(Ts-Tp)));
//Number of tubes
N=((A)/(pi*id*l));
end Ex9_2;
